/*
 * Decompiled with CFR 0.152.
 */
package dev.figboot.autool.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class CountedInputStream
extends InputStream {
    private final InputStream parent;
    private final Object countLock = new Object();
    private long count;
    private long markCount;
    private int markReadLimit;
    private final Consumer<Long> postIncCallback;

    public CountedInputStream(InputStream parent, Consumer<Long> postIncCallback) {
        this.parent = parent;
        this.count = 0L;
        this.markCount = 0L;
        this.markReadLimit = 0;
        this.postIncCallback = postIncCallback;
    }

    public CountedInputStream(InputStream parent) {
        this(parent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incCount(long l) {
        long cpy;
        Object object = this.countLock;
        synchronized (object) {
            cpy = this.count;
            this.count += l;
            if (this.markSupported() && this.markReadLimit > 0 && this.count - this.markCount > (long)this.markReadLimit) {
                this.markReadLimit = 0;
                this.markCount = 0L;
            }
        }
        if (this.postIncCallback != null) {
            this.postIncCallback.accept(cpy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        Object object = this.countLock;
        synchronized (object) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCount() {
        Object object = this.countLock;
        synchronized (object) {
            this.count = this.markCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCountAndReset() {
        Object object = this.countLock;
        synchronized (object) {
            long temp = this.count;
            this.count = 0L;
            return temp;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int res = this.parent.read(b);
        this.incCount(res);
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = this.parent.read(b, off, len);
        this.incCount(res);
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        long res = this.parent.skip(n);
        this.incCount(res);
        return res;
    }

    @Override
    public int available() throws IOException {
        return this.parent.available();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.markSupported()) {
            this.markCount = this.count;
            this.markReadLimit = readlimit;
        }
        this.parent.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markSupported() && this.markReadLimit > 0) {
            this.resetCount();
        }
        this.parent.reset();
    }

    @Override
    public boolean markSupported() {
        return this.parent.markSupported();
    }

    @Override
    public int read() throws IOException {
        int res = this.parent.read();
        if (res >= 0) {
            this.incCount(1L);
        }
        return res;
    }
}

