/*
 * Decompiled with CFR 0.152.
 */
package dev.figboot.autool.ui;

import dev.figboot.autool.ui.ProgressUpdater;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CLIProgressUpdater
implements ProgressUpdater {
    private final ScheduledExecutorService scheduler;
    private final Object progressLock = new Object();
    private String status;
    private int maxProgress;
    private int progress;

    public CLIProgressUpdater() {
        this.scheduler = new ScheduledThreadPoolExecutor(1);
        this.scheduler.scheduleAtFixedRate(this::updateProgress, 1000L, 500L, TimeUnit.MILLISECONDS);
        this.status = "";
        this.progress = 0;
        this.maxProgress = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeStatus(String status) {
        Object object = this.progressLock;
        synchronized (object) {
            this.status = status;
            this.progress = 0;
            this.updateProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxProgress(int max) {
        Object object = this.progressLock;
        synchronized (object) {
            this.maxProgress = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProgress(int progress) {
        Object object = this.progressLock;
        synchronized (object) {
            this.progress = progress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgress() {
        int percentComplete;
        String status;
        Object object = this.progressLock;
        synchronized (object) {
            status = this.status;
            percentComplete = 100 * this.progress / this.maxProgress;
        }
        System.out.format("%s (%d%% complete)\n", status, percentComplete);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.scheduler.shutdown();
        if (!this.scheduler.awaitTermination(5000L, TimeUnit.SECONDS)) {
            System.err.println("The executor did not shut down in time :(");
        }
    }

    @Override
    public void error(Object message) {
        System.err.println(message);
    }
}

