/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.visuals;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.action.PositionAndAngle;
import com.moulberry.flashback.packet.FlashbackAccurateEntityPosition;
import com.moulberry.flashback.playback.ReplayServer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class AccurateEntityPositionHandler {
    private static Int2ObjectMap<List<PositionAndAngle>> currentData = null;
    private static Int2ObjectMap<List<PositionAndAngle>> pendingData = null;

    public static void tick() {
        currentData = pendingData;
        pendingData = null;
    }

    public static void update(FlashbackAccurateEntityPosition data) {
        if (pendingData == null) {
            pendingData = new Int2ObjectOpenHashMap();
        }
        pendingData.put(data.entityId(), data.positionAndAngles());
    }

    @Nullable
    public static Vector2f getAccurateRotation(class_1297 entity, float partialTick) {
        if (currentData != null && currentData.containsKey(entity.method_5628())) {
            List positionAndAngles = (List)currentData.get(entity.method_5628());
            float amount = partialTick * (float)(positionAndAngles.size() - 1);
            int floorAmount = (int)amount;
            PositionAndAngle floorPosition = (PositionAndAngle)positionAndAngles.get(floorAmount);
            int ceilAmount = floorAmount + 1;
            if (ceilAmount >= positionAndAngles.size()) {
                return new Vector2f(floorPosition.pitch(), floorPosition.yaw());
            }
            PositionAndAngle ceilPosition = (PositionAndAngle)positionAndAngles.get(ceilAmount);
            float partialAmount = amount - (float)floorAmount;
            float yaw = floorPosition.yaw() + class_3532.method_15393((float)(ceilPosition.yaw() - floorPosition.yaw())) * partialAmount;
            float pitch = floorPosition.pitch() + class_3532.method_15393((float)(ceilPosition.pitch() - floorPosition.pitch())) * partialAmount;
            return new Vector2f(class_3532.method_15393((float)pitch), class_3532.method_15393((float)yaw));
        }
        return null;
    }

    @Nullable
    public static Vector3d getAccuratePosition(class_1297 entity, float partialTick) {
        if (entity.method_5765() || !class_310.method_1551().field_1690.method_31044().method_31034()) {
            return null;
        }
        if (currentData != null && currentData.containsKey(entity.method_5628())) {
            List positionAndAngles = (List)currentData.get(entity.method_5628());
            float amount = partialTick * (float)(positionAndAngles.size() - 1);
            int floorAmount = (int)amount;
            PositionAndAngle floorPosition = (PositionAndAngle)positionAndAngles.get(floorAmount);
            int ceilAmount = floorAmount + 1;
            if (ceilAmount >= positionAndAngles.size()) {
                return new Vector3d(floorPosition.x(), floorPosition.y(), floorPosition.z());
            }
            PositionAndAngle ceilPosition = (PositionAndAngle)positionAndAngles.get(ceilAmount);
            float partialAmount = amount - (float)floorAmount;
            double x = floorPosition.x() + (ceilPosition.x() - floorPosition.x()) * (double)partialAmount;
            double y = floorPosition.y() + (ceilPosition.y() - floorPosition.y()) * (double)partialAmount;
            double z = floorPosition.z() + (ceilPosition.z() - floorPosition.z()) * (double)partialAmount;
            return new Vector3d(x, y, z);
        }
        return null;
    }

    public static void apply(class_638 level, class_9779 deltaTracker) {
        if (currentData == null || level == null) {
            return;
        }
        float partialTick = deltaTracker.method_60637(true);
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null) {
            for (Int2ObjectMap.Entry entry : currentData.int2ObjectEntrySet()) {
                class_1297 entity = level.method_8469(entry.getIntKey());
                if (entity == null) continue;
                List positionAndAngles = (List)entry.getValue();
                float amount = partialTick * (float)(positionAndAngles.size() - 1);
                int floorAmount = (int)amount;
                PositionAndAngle floorPosition = (PositionAndAngle)positionAndAngles.get(floorAmount);
                int ceilAmount = floorAmount + 1;
                if (ceilAmount >= positionAndAngles.size()) {
                    AccurateEntityPositionHandler.applyPosition(entity, floorPosition.x(), floorPosition.y(), floorPosition.z(), floorPosition.yaw(), floorPosition.pitch());
                    continue;
                }
                PositionAndAngle ceilPosition = (PositionAndAngle)positionAndAngles.get(ceilAmount);
                float partialAmount = amount - (float)floorAmount;
                double x = floorPosition.x() + (ceilPosition.x() - floorPosition.x()) * (double)partialAmount;
                double y = floorPosition.y() + (ceilPosition.y() - floorPosition.y()) * (double)partialAmount;
                double z = floorPosition.z() + (ceilPosition.z() - floorPosition.z()) * (double)partialAmount;
                float yaw = floorPosition.yaw() + class_3532.method_15393((float)(ceilPosition.yaw() - floorPosition.yaw())) * partialAmount;
                float pitch = floorPosition.pitch() + class_3532.method_15393((float)(ceilPosition.pitch() - floorPosition.pitch())) * partialAmount;
                AccurateEntityPositionHandler.applyPosition(entity, x, y, z, class_3532.method_15393((float)yaw), class_3532.method_15393((float)pitch));
            }
        }
    }

    private static void applyPosition(class_1297 entity, double x, double y, double z, float yaw, float pitch) {
        if (!entity.method_5765() && class_310.method_1551().method_1560() == entity && class_310.method_1551().field_1690.method_31044().method_31034()) {
            entity.method_5808(x, y, z, yaw, pitch);
        }
        entity.method_36456(yaw);
        entity.method_36457(pitch);
        entity.method_5847(yaw);
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.field_6265 = 0;
            livingEntity.field_6259 = livingEntity.field_6241;
            livingEntity.field_5982 = livingEntity.method_36454();
            livingEntity.field_6004 = livingEntity.method_36455();
        }
    }
}

