/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.sound;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.sound.FlashbackAudioBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1140;
import net.minecraft.class_243;
import net.minecraft.class_4224;
import net.minecraft.class_4225;
import net.minecraft.class_4235;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;

public class FlashbackAudioManager {
    private static final LoadingCache<Path, FlashbackAudioBuffer> audioBufferCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Path, FlashbackAudioBuffer>(){

        public FlashbackAudioBuffer load(@NotNull Path path) {
            FlashbackAudioBuffer loaded = FlashbackAudioBuffer.load(path);
            if (loaded != null) {
                return loaded;
            }
            return FlashbackAudioBuffer.EMPTY;
        }
    });
    private static final List<PlayingAudioInstance> instances = new ArrayList<PlayingAudioInstance>();
    private static boolean handling = false;

    public static FlashbackAudioBuffer getBuffer(Path path) {
        return (FlashbackAudioBuffer)audioBufferCache.getUnchecked((Object)path);
    }

    public static void invalidateLoadedBuffers() {
        for (FlashbackAudioBuffer audioBuffer : audioBufferCache.asMap().values()) {
            audioBuffer.invalidate(true);
        }
    }

    public static void startHandling() {
        if (handling) {
            throw new IllegalStateException();
        }
        handling = true;
    }

    public static void finishHandling() {
        if (!handling) {
            throw new IllegalStateException();
        }
        handling = false;
        for (PlayingAudioInstance instance : instances) {
            if (!instance.claimed) {
                instance.channelHandle.method_19735(class_4224::method_19655);
            }
            instance.claimed = false;
        }
    }

    public static void playAt(class_1140 soundEngine, FlashbackAudioBuffer audioBuffer, int startTick, float seconds, float speed) {
        float clampedSpeed;
        if (!handling) {
            return;
        }
        PlayingAudioInstance instance = FlashbackAudioManager.findMatchingInstance(audioBuffer, startTick, seconds);
        if (instance == null) {
            instance = new PlayingAudioInstance(audioBuffer);
            instances.add(instance);
        }
        boolean updateSpeed = instance.speed != (clampedSpeed = Math.max(0.1f, Math.min(10.0f, speed)));
        instance.startTick = startTick;
        instance.seconds = seconds;
        instance.speed = clampedSpeed;
        instance.claimed = true;
        if (instance.channelHandle == null || instance.channelHandle.method_19732()) {
            class_4235 channelAccess = soundEngine.field_18949;
            CompletableFuture handleFuture = channelAccess.method_19723(class_4225.class_4105.field_18352);
            instance.channelHandle = (class_4235.class_4236)handleFuture.join();
            if (instance.channelHandle == null) {
                ReplayUI.setInfoOverlay("Unable to play audio: out of channels");
                return;
            }
            instance.channelHandle.method_19735(channel -> {
                channel.method_19639(clampedSpeed);
                channel.method_19647(1.0f);
                channel.method_19657();
                channel.method_19645(false);
                channel.method_19641(class_243.field_1353);
                channel.method_19649(false);
                AL10.alGetError();
                channel.method_19642(audioBuffer.soundBuffer());
                if (AL10.alGetError() != 0) {
                    Flashback.LOGGER.error("Error attaching sound buffer, invalidating and trying again");
                    audioBuffer.invalidate(false);
                    channel.method_19642(audioBuffer.soundBuffer());
                    if (AL10.alGetError() != 0) {
                        Flashback.LOGGER.error("Error attaching sound buffer a second time... bailing");
                        return;
                    }
                }
                AL10.alSourcef((int)channel.field_18893, (int)4132, (float)seconds);
                channel.method_19650();
            });
        } else {
            instance.channelHandle.method_19735(channel -> {
                float secOffset;
                channel.method_19654();
                if (updateSpeed) {
                    channel.method_19639(clampedSpeed);
                }
                if (Math.abs((secOffset = AL10.alGetSourcef((int)channel.field_18893, (int)4132)) - seconds) > 0.05f) {
                    AL10.alSourcef((int)channel.field_18893, (int)4132, (float)seconds);
                }
            });
        }
    }

    @Nullable
    private static PlayingAudioInstance findMatchingInstance(FlashbackAudioBuffer audioBuffer, int startTick, float seconds) {
        if (instances.isEmpty()) {
            return null;
        }
        for (PlayingAudioInstance instance : instances) {
            if (instance.audioBuffer != audioBuffer || instance.claimed || instance.startTick != startTick) continue;
            return instance;
        }
        float bestSecondsDelta = Float.MAX_VALUE;
        PlayingAudioInstance bestInstance = null;
        for (PlayingAudioInstance instance : instances) {
            float delta;
            if (instance.audioBuffer != audioBuffer || instance.claimed || !((delta = Math.abs(instance.seconds - seconds)) < bestSecondsDelta)) continue;
            bestSecondsDelta = delta;
            bestInstance = instance;
        }
        return bestInstance;
    }

    public static void stopAll() {
        if (handling) {
            throw new IllegalStateException();
        }
        for (PlayingAudioInstance instance : instances) {
            instance.channelHandle.method_19735(class_4224::method_19655);
        }
        instances.clear();
    }

    public static void pauseAll() {
        if (handling) {
            throw new IllegalStateException();
        }
        for (PlayingAudioInstance instance : instances) {
            instance.channelHandle.method_19735(class_4224::method_19653);
        }
    }

    private static class PlayingAudioInstance {
        private final FlashbackAudioBuffer audioBuffer;
        private class_4235.class_4236 channelHandle;
        private int startTick;
        private float seconds;
        private float speed = 1.0f;
        private boolean claimed = false;

        public PlayingAudioInstance(FlashbackAudioBuffer audioBuffer) {
            this.audioBuffer = audioBuffer;
        }
    }
}

