/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.packet;

import com.moulberry.flashback.Flashback;
import io.netty.handler.codec.DecoderException;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public interface FlashbackVoiceChatSound
extends class_8710 {
    public static final class_8710.class_9154<FlashbackVoiceChatSound> TYPE = new class_8710.class_9154(Flashback.createResourceLocation("voice_chat_sound"));
    public static final class_9139<class_2540, FlashbackVoiceChatSound> STREAM_CODEC = new FlashbackVoiceChatSoundStreamCodec();
    public static final byte TYPE_STATIC_SOUND = 0;
    public static final byte TYPE_LOCATIONAL_SOUND = 1;
    public static final byte TYPE_ENTITY_SOUND = 2;

    default public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public UUID source();

    public short[] samples();

    public void writeExtraData(class_2540 var1);

    public static class FlashbackVoiceChatSoundStreamCodec
    implements class_9139<class_2540, FlashbackVoiceChatSound> {
        public FlashbackVoiceChatSound decode(class_2540 friendlyByteBuf) {
            UUID uuid = friendlyByteBuf.method_10790();
            int sampleCount = friendlyByteBuf.method_10816();
            short[] samples = new short[sampleCount];
            for (int i = 0; i < sampleCount; ++i) {
                samples[i] = friendlyByteBuf.readShort();
            }
            byte type = friendlyByteBuf.readByte();
            switch (type) {
                case 0: {
                    return new SoundStatic(uuid, samples);
                }
                case 1: {
                    class_243 position = friendlyByteBuf.method_52996();
                    float distance = friendlyByteBuf.readFloat();
                    return new SoundLocational(uuid, samples, position, distance);
                }
                case 2: {
                    boolean whispering = friendlyByteBuf.readBoolean();
                    float distance = friendlyByteBuf.readFloat();
                    return new SoundEntity(uuid, samples, whispering, distance);
                }
            }
            throw new DecoderException("Unknown voice chat type: " + type);
        }

        public void encode(class_2540 friendlyByteBuf, FlashbackVoiceChatSound packet) {
            friendlyByteBuf.method_10797(packet.source());
            short[] samples = packet.samples();
            friendlyByteBuf.method_10804(samples.length);
            for (short sample : samples) {
                friendlyByteBuf.method_52998((int)sample);
            }
            packet.writeExtraData(friendlyByteBuf);
        }
    }

    public record SoundEntity(UUID source, short[] samples, boolean whispering, float distance) implements FlashbackVoiceChatSound
    {
        @Override
        public void writeExtraData(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997(2);
            friendlyByteBuf.method_52964(this.whispering);
            friendlyByteBuf.method_52941(this.distance);
        }
    }

    public record SoundLocational(UUID source, short[] samples, class_243 position, float distance) implements FlashbackVoiceChatSound
    {
        @Override
        public void writeExtraData(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997(1);
            friendlyByteBuf.method_52955(this.position);
            friendlyByteBuf.method_52941(this.distance);
        }
    }

    public record SoundStatic(UUID source, short[] samples) implements FlashbackVoiceChatSound
    {
        @Override
        public void writeExtraData(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52997(0);
        }
    }
}

