/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.FreezeSlowdownFormula;
import com.moulberry.flashback.combo_options.GlowingOverride;
import com.moulberry.flashback.configuration.FlashbackConfigV1;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.exporting.ExportJob;
import com.moulberry.flashback.exporting.ExportJobQueue;
import com.moulberry.flashback.exporting.PerfectFrames;
import com.moulberry.flashback.ext.MinecraftExt;
import com.moulberry.flashback.keyframe.handler.MinecraftKeyframeHandler;
import com.moulberry.flashback.keyframe.handler.TickrateKeyframeCapture;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.sound.FlashbackAudioManager;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.visuals.AccurateEntityPositionHandler;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.io.File;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1132;
import net.minecraft.class_1144;
import net.minecraft.class_11545;
import net.minecraft.class_11548;
import net.minecraft.class_11653;
import net.minecraft.class_128;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2896;
import net.minecraft.class_2915;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_32;
import net.minecraft.class_320;
import net.minecraft.class_3283;
import net.minecraft.class_3928;
import net.minecraft.class_4071;
import net.minecraft.class_4093;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_5498;
import net.minecraft.class_635;
import net.minecraft.class_638;
import net.minecraft.class_6904;
import net.minecraft.class_746;
import net.minecraft.class_7497;
import net.minecraft.class_7569;
import net.minecraft.class_761;
import net.minecraft.class_8563;
import net.minecraft.class_8921;
import net.minecraft.class_9779;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public abstract class MixinMinecraft
extends class_4093<Runnable>
implements MinecraftExt {
    @Shadow
    @Final
    public File field_1697;
    @Shadow
    @Nullable
    private class_1132 field_1766;
    @Shadow
    private boolean field_1759;
    @Shadow
    @Nullable
    private class_4071 field_18175;
    @Shadow
    @Nullable
    private class_2535 field_1746;
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_1297 field_1719;
    @Shadow
    @Final
    public class_9779.class_9781 field_52750;
    @Shadow
    public long field_46553;
    @Shadow
    @Final
    public class_315 field_1690;
    @Shadow
    @Final
    public class_761 field_1769;
    @Shadow
    @Final
    private class_7497 field_62106;
    @Unique
    private boolean inReplayLast = false;
    @Unique
    private int serverTickFreezeDelayStart = -1;
    @Unique
    private double clientTickFreezeDelayStart = -1.0;
    @Unique
    private final class_9779.class_9781 localPlayerTimer = new class_9779.class_9781(20.0f, 0L, FloatUnaryOperator.identity());
    @Unique
    private final AtomicBoolean applyKeyframes = new AtomicBoolean(false);

    public MixinMinecraft(String string) {
        super(string);
    }

    @Shadow
    public abstract void method_44376(class_7569 var1);

    @Shadow
    public abstract void method_1507(@Nullable class_437 var1);

    @Shadow
    protected abstract void method_1523(boolean var1);

    @Shadow
    protected abstract void method_54579();

    @Shadow
    public abstract class_320 method_1548();

    @Shadow
    protected abstract float method_54785(float var1);

    @Shadow
    public abstract void method_72100();

    @Shadow
    @Nullable
    public abstract class_1297 method_1560();

    @Inject(method={"pauseGame"}, at={@At(value="HEAD")}, cancellable=true)
    public void pauseGame(boolean bl, CallbackInfo ci) {
        if (Flashback.EXPORT_JOB != null) {
            ci.cancel();
        }
    }

    @Inject(method={"renderNames"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderNames(CallbackInfoReturnable<Boolean> cir) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderNametags) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"shouldEntityAppearGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldEntityAppearGlowing(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null) {
            GlowingOverride glowingOverride = editorState.glowingOverride.get(entity.method_5667());
            if (glowingOverride == GlowingOverride.FORCE_GLOW) {
                cir.setReturnValue((Object)true);
            } else if (glowingOverride == GlowingOverride.FORCE_NO_GLOW) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @WrapOperation(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;updateSource(Lnet/minecraft/client/Camera;)V")})
    public void runTick_updateSource(class_1144 instance, class_4184 camera, Operation<Void> original) {
        class_4184 audioCamera;
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && (audioCamera = editorState.getAudioCamera()) != null) {
            original.call(new Object[]{instance, audioCamera});
            return;
        }
        original.call(new Object[]{instance, camera});
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/pipeline/RenderTarget;blitToScreen()V", shift=At.Shift.AFTER)})
    public void afterMainBlit(boolean bl, CallbackInfo ci) {
        if (!RenderSystem.isOnRenderThread()) {
            return;
        }
        ReplayUI.drawOverlay();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        boolean inReplay;
        if (Flashback.RECORDER != null) {
            Flashback.RECORDER.endTick(false);
        }
        EditorStateManager.saveIfNeeded();
        ReplayServer replayServer = Flashback.getReplayServer();
        boolean bl = inReplay = replayServer != null;
        if (inReplay != this.inReplayLast) {
            this.inReplayLast = inReplay;
            if (inReplay) {
                class_310.method_1551().field_1690.field_1842 = false;
            } else {
                EditorStateManager.reset();
            }
        }
        FlashbackConfigV1 config = Flashback.getConfig();
        if (inReplay && !config.advanced.disableThirdPersonCancel && ReplayUI.isActive() && this.field_1724 != null && this.method_1560() == this.field_1724 && this.field_1690.method_31044() != class_5498.field_26664) {
            this.field_1690.method_31043(class_5498.field_26664);
            this.field_1769.method_3292();
            ReplayUI.setInfoOverlay("Forced perspective to First-Person");
        }
    }

    @Inject(method={"getTickTargetMillis"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTickTargetMillis(float f, CallbackInfoReturnable<Float> cir) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null) {
            if (this.field_1687 == null) {
                this.clientTickFreezeDelayStart = -1.0;
                this.serverTickFreezeDelayStart = -1;
                return;
            }
            EditorState editorState = EditorStateManager.getCurrent();
            if (editorState != null && !replayServer.replayPaused) {
                class_8921 tickRateManager;
                class_9779.class_9781 class_97812;
                double partialReplayTick = replayServer.getPartialReplayTick();
                TickrateKeyframeCapture capture = new TickrateKeyframeCapture();
                editorState.applyKeyframes(capture, (float)partialReplayTick);
                if (capture.frozen && capture.frozenDelay > 0 && (class_97812 = this.field_52750) instanceof class_9779.class_9781) {
                    class_9779.class_9781 timer = class_97812;
                    if (this.clientTickFreezeDelayStart < 0.0) {
                        this.clientTickFreezeDelayStart = this.field_46553 + 1L;
                        this.serverTickFreezeDelayStart = (int)partialReplayTick;
                        class_8921 tickRateManager2 = this.field_1687.method_54719();
                        tickRateManager2.method_54747(capture.frozenDelay <= 5 ? 1 : 2);
                    }
                    double freezeClientTicks = capture.frozenDelay <= 5 ? 0.999 : 1.999;
                    double freezeDerivative = capture.frozenDelay <= 5 ? 1.0 : 0.5;
                    double deltaFromStart = partialReplayTick - (double)this.serverTickFreezeDelayStart;
                    if (deltaFromStart >= 0.0 && deltaFromStart <= (double)capture.frozenDelay) {
                        double freezePowerBase = FreezeSlowdownFormula.getFreezePowerBase(capture.frozenDelay, freezeDerivative);
                        double clientTicks = freezeClientTicks * FreezeSlowdownFormula.calculateFreezeClientTick(deltaFromStart, capture.frozenDelay, freezePowerBase);
                        double currentClientTicks = (double)((float)this.field_46553 + timer.field_51959) - this.clientTickFreezeDelayStart;
                        double freezeRate = Math.max((double)0.01f, Math.min(1.0, clientTicks - currentClientTicks));
                        float tickrate = Math.max(1.0f, capture.tickrate) * (float)freezeRate;
                        cir.setReturnValue((Object)Float.valueOf(1000.0f / tickrate));
                        return;
                    }
                } else {
                    this.clientTickFreezeDelayStart = -1.0;
                    this.serverTickFreezeDelayStart = -1;
                }
                if ((tickRateManager = this.field_1687.method_54719()).method_54751()) {
                    float manualMultiplier = replayServer.getDesiredTickRate(true) / 20.0f;
                    cir.setReturnValue((Object)Float.valueOf(1000.0f / Math.max(1.0f, capture.tickrate * manualMultiplier)));
                }
            } else {
                class_8921 tickRateManager = this.field_1687.method_54719();
                if (tickRateManager.method_54751()) {
                    cir.setReturnValue((Object)Float.valueOf(tickRateManager.method_54749()));
                }
            }
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="HEAD")})
    public void disconnectHead(class_437 screen, boolean isTransferring, CallbackInfo ci) {
        try {
            if (Flashback.getConfig().recordingControls.automaticallyFinish && Flashback.RECORDER != null && !isTransferring) {
                Flashback.finishRecordingReplay();
            }
        }
        catch (Exception e) {
            Flashback.LOGGER.error("Failed to finish replay on disconnect", (Throwable)e);
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="RETURN")})
    public void disconnectReturn(class_437 screen, boolean bl, CallbackInfo ci) {
        Flashback.updateIsInReplay();
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;runAllTasks()V", shift=At.Shift.AFTER)})
    public void runTick_runAllTasks(boolean runTick, CallbackInfo ci) {
        if (ExportJobQueue.drainingQueue) {
            if (ExportJobQueue.queuedJobs.isEmpty()) {
                ExportJobQueue.drainingQueue = false;
            } else if (Flashback.EXPORT_JOB == null) {
                Flashback.EXPORT_JOB = new ExportJob(ExportJobQueue.queuedJobs.removeFirst());
            }
        }
        if (Flashback.EXPORT_JOB != null && !ReplayUI.isActive()) {
            try {
                PerfectFrames.enable();
                Flashback.EXPORT_JOB.run();
            }
            finally {
                PerfectFrames.disable();
                Flashback.EXPORT_JOB = null;
            }
        }
        if (Flashback.isInReplay()) {
            int localPlayerTicks = this.localPlayerTimer.method_60640(class_156.method_658(), runTick);
            if (this.flashback$overridingLocalPlayerTimer()) {
                localPlayerTicks = Math.min(10, localPlayerTicks);
                for (int i = 0; i < localPlayerTicks; ++i) {
                    this.field_1687.method_18472(arg_0 -> ((class_638)this.field_1687).method_18646(arg_0), (class_1297)this.field_1724);
                }
            }
        }
    }

    @Override
    public boolean flashback$overridingLocalPlayerTimer() {
        return !Flashback.isExporting() && this.field_1687 != null && this.field_1724 != null && !this.field_1724.method_5765() && !this.field_1724.method_31481() && Math.round(this.method_54785(50.0f)) != 50;
    }

    @Override
    public float flashback$getLocalPlayerPartialTick(float originalPartialTick) {
        if (this.method_1560() != this.field_1724 || !this.flashback$overridingLocalPlayerTimer()) {
            return originalPartialTick;
        }
        return this.localPlayerTimer.method_60637(true);
    }

    @Override
    public void flashback$applyKeyframes() {
        this.applyKeyframes.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Window;setErrorSection(Ljava/lang/String;)V", ordinal=1)}, cancellable=true)
    public void runTick_setErrorSection(boolean bl, CallbackInfo ci) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer == null) {
            FlashbackAudioManager.stopAll();
            return;
        }
        class_746 player = this.field_1724;
        class_9779.class_9781 deltaTracker = this.field_52750;
        if (Flashback.RECORDER != null && player != null) {
            float partialTick = deltaTracker.method_60637(true);
            Flashback.RECORDER.trackPartialPosition((class_1297)player, partialTick);
        }
        AccurateEntityPositionHandler.apply(this.field_1687, (class_9779)deltaTracker);
        boolean paused = replayServer.replayPaused;
        boolean forceApplyKeyframes = this.applyKeyframes.compareAndSet(true, false);
        if (paused) {
            FlashbackAudioManager.pauseAll();
        }
        if (!paused || forceApplyKeyframes) {
            if (!paused) {
                FlashbackAudioManager.startHandling();
            }
            try {
                EditorState editorState = EditorStateManager.get(replayServer.getMetadata().replayIdentifier);
                editorState.applyKeyframes(new MinecraftKeyframeHandler((class_310)this), (float)replayServer.getPartialReplayTick());
            }
            finally {
                if (!paused) {
                    FlashbackAudioManager.finishHandling();
                }
            }
        }
        if (!replayServer.doClientRendering()) {
            ci.cancel();
        }
    }

    @Override
    public void flashback$startReplayServer(class_32.class_5143 levelStorageAccess, class_3283 packRepository, class_6904 stem, UUID playbackUUID, Path path) {
        this.method_72100();
        Instant instant = Instant.now();
        class_11653 levelLoadTracker = new class_11653(0L);
        class_3928 levelLoadingScreen = new class_3928(levelLoadTracker, class_3928.class_9678.field_51489);
        this.method_1507((class_437)levelLoadingScreen);
        int i = class_8563.field_51859 + 6;
        try {
            class_11545 levelLoadListener = class_11545.method_72283((class_11545)levelLoadTracker, (class_11545)class_11548.method_72291());
            this.field_1766 = (class_1132)MinecraftServer.method_29740(thread -> new ReplayServer((Thread)thread, (class_310)this, levelStorageAccess, packRepository, stem, this.field_62106, levelLoadListener, playbackUUID, path));
            Flashback.updateIsInReplay();
            levelLoadTracker.method_72900(this.field_1766.method_73044(i));
            this.field_1759 = true;
            this.method_44376(class_7569.method_44586());
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Starting replay server");
            throw new class_148(crashReport);
        }
        long delay = TimeUnit.SECONDS.toNanos(1L) / 60L;
        while (!this.field_1766.method_3820() || this.field_18175 != null) {
            long end = class_156.method_648() + delay;
            levelLoadingScreen.method_25393();
            if (this.field_18175 != null) {
                this.field_18175.method_74217();
            }
            this.method_1523(false);
            this.method_5383();
            this.method_18857(() -> class_156.method_648() > end);
            this.method_54579();
        }
        Duration duration = Duration.between(instant, Instant.now());
        SocketAddress socketAddress = this.field_1766.method_3787().method_14353();
        class_2535 connection = class_2535.method_10769((SocketAddress)socketAddress);
        connection.method_52902(socketAddress.toString(), 0, (class_2896)new class_635(connection, (class_310)this, null, null, false, duration, component -> {}, levelLoadTracker, null));
        connection.method_10743((class_2596)new class_2915(this.method_1548().method_1676(), this.method_1548().method_44717()));
        this.field_1746 = connection;
    }
}

