/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.io;

import com.moulberry.flashback.action.Action;
import com.moulberry.flashback.action.ActionRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_5455;
import net.minecraft.class_9129;

public class ReplayWriter {
    private final ByteBuf dataBufferInner = Unpooled.buffer();
    private class_9129 dataBuffer;
    private Reference2IntMap<Action> registeredActions;
    private Action writingAction = null;
    private class_5455 registryAccess;
    private int snapshotSizeWriterIndex = -1;
    private int actionSizeWriterIndex = -1;
    private static final int STATE_EMPTY = 0;
    private static final int STATE_WRITING_SNAPSHOT = 1;
    private static final int STATE_WRITING_DATA = 2;
    public int state = 0;

    public ReplayWriter(class_5455 registryAccess) {
        this.dataBuffer = new class_9129(this.dataBufferInner, registryAccess);
        this.registryAccess = registryAccess;
        this.writeHeader();
    }

    private void writeHeader() {
        this.registeredActions = new Reference2IntOpenHashMap();
        this.registeredActions.defaultReturnValue(-1);
        this.dataBuffer.method_52990(0);
        this.dataBuffer.method_53002(-679417724);
        List<Action> actions = ActionRegistry.getActions();
        this.dataBuffer.method_10804(actions.size());
        for (Action action : actions) {
            this.dataBuffer.method_10812(action.name());
            this.registeredActions.put((Object)action, this.registeredActions.size());
        }
        this.state = 0;
    }

    public void setRegistryAccess(class_5455 registryAccess) {
        class_9129 newDataBuffer = new class_9129(this.dataBufferInner, registryAccess);
        newDataBuffer.method_52990(this.dataBuffer.writerIndex());
        newDataBuffer.method_52988(this.dataBuffer.readerIndex());
        this.dataBuffer = newDataBuffer;
        this.registryAccess = registryAccess;
    }

    public void startSnapshot() {
        if (this.state != 0) {
            throw new IllegalStateException("Can only start snapshot in STATE_EMPTY");
        }
        this.state = 1;
        this.snapshotSizeWriterIndex = this.dataBuffer.writerIndex();
        this.dataBuffer.method_53002(-559038737);
    }

    public void endSnapshot() {
        if (this.state == 1) {
            this.state = 2;
            if (this.snapshotSizeWriterIndex < 0) {
                throw new IllegalStateException("Snapshot size index wasn't set (" + this.snapshotSizeWriterIndex + ")");
            }
        } else {
            throw new IllegalStateException("Can only end snapshot in STATE_WRITING_SNAPSHOT");
        }
        int endPosition = this.dataBuffer.writerIndex();
        int written = this.dataBuffer.writerIndex() - this.snapshotSizeWriterIndex - 4;
        this.dataBuffer.method_52990(this.snapshotSizeWriterIndex);
        this.dataBuffer.method_53002(written);
        this.dataBuffer.method_52990(endPosition);
        this.snapshotSizeWriterIndex = -1;
    }

    public void startAndFinishAction(Action action) {
        Objects.requireNonNull(action);
        if (this.writingAction != null) {
            throw new RuntimeException("startAndFinishAction() called while still writing " + String.valueOf(action.name()));
        }
        int id = this.registeredActions.getInt((Object)action);
        if (id < 0) {
            throw new RuntimeException("Unknown action: " + String.valueOf(action.name()));
        }
        this.dataBuffer.method_10804(id);
        this.dataBuffer.method_53002(0);
        this.actionSizeWriterIndex = -1;
    }

    public void startAction(Action action) {
        Objects.requireNonNull(action);
        if (this.writingAction != null) {
            throw new RuntimeException("startAction() called while still writing " + String.valueOf(action.name()));
        }
        this.writingAction = action;
        int id = this.registeredActions.getInt((Object)action);
        if (id < 0) {
            throw new RuntimeException("Unknown action: " + String.valueOf(action.name()));
        }
        this.dataBuffer.method_10804(id);
        this.actionSizeWriterIndex = this.dataBuffer.writerIndex();
        this.dataBuffer.method_53002(0);
    }

    public void finishAction(Action action) {
        Objects.requireNonNull(action);
        if (this.writingAction == null) {
            throw new IllegalStateException("finishAction() called before startAction()");
        }
        if (this.writingAction != action) {
            throw new IllegalStateException("finishAction() called with wrong action, expected " + String.valueOf(this.writingAction.name()) + ", got " + String.valueOf(action.name()));
        }
        this.writingAction = null;
        if (this.actionSizeWriterIndex < 0) {
            throw new IllegalStateException("Action size index wasn't set (" + this.actionSizeWriterIndex + ")");
        }
        int endPosition = this.dataBuffer.writerIndex();
        int written = this.dataBuffer.writerIndex() - this.actionSizeWriterIndex - 4;
        this.dataBuffer.method_52990(this.actionSizeWriterIndex);
        this.dataBuffer.method_53002(written);
        this.dataBuffer.method_52990(endPosition);
        this.actionSizeWriterIndex = -1;
    }

    public class_9129 friendlyByteBuf() {
        return this.dataBuffer;
    }

    public class_5455 registryAccess() {
        return this.registryAccess;
    }

    public byte[] popBytes() {
        if (this.writingAction != null) {
            throw new IllegalStateException("popBytes() called while still writing action " + String.valueOf(this.writingAction.name()));
        }
        byte[] replay = new byte[this.dataBuffer.writerIndex()];
        this.dataBuffer.method_52952(0, replay);
        this.writeHeader();
        return replay;
    }
}

