/*
 * Decompiled with CFR 0.152.
 */
package com.lukasabbe.bookshelfinspector.renderer;

import com.lukasabbe.bookshelfinspector.BookshelfInspectorClient;
import com.lukasabbe.bookshelfinspector.data.BookData;
import com.lukasabbe.bookshelfinspector.data.Tags;
import com.lukasabbe.bookshelfinspector.network.packets.BookShelfInventoryRequestPayload;
import com.lukasabbe.bookshelfinspector.network.packets.LecternInventoryRequestPayload;
import com.lukasabbe.bookshelfinspector.network.packets.ShelfInventoryRequestPayload;
import com.lukasabbe.bookshelfinspector.platform.Services;
import java.util.OptionalInt;
import net.minecraft.class_11586;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_7714;

public class Inspector {
    public void inspect(class_310 client) {
        class_2680 blockState;
        if (!BookshelfInspectorClient.modAvailable) {
            return;
        }
        if (client.method_1560() == null || client.field_1724 == null) {
            return;
        }
        class_239 hit = client.method_1560().method_5745(5.0, 0.0f, false);
        class_239.class_240 type = hit.method_17783();
        if (type != class_239.class_240.field_1332) {
            this.resetBookShelfData();
            return;
        }
        class_3965 blockHitResult = (class_3965)hit;
        class_2338 pos = blockHitResult.method_17777();
        if (BookshelfInspectorClient.bookShelfData.latestPos == null) {
            BookshelfInspectorClient.bookShelfData.latestPos = pos;
        }
        if (!BookshelfInspectorClient.bookShelfData.latestPos.equals((Object)pos)) {
            this.resetBookShelfData();
            BookshelfInspectorClient.currentBookData = BookData.empty();
        }
        BookshelfInspectorClient.bookShelfData.latestPos = pos;
        BookshelfInspectorClient.bookShelfData.latestBlockState = blockState = client.field_1724.method_73183().method_8320(pos);
        if (blockState.method_26164(Tags.CHISELED_BOOKSHELVES)) {
            this.bookShelfInspect(pos, blockHitResult, client);
            return;
        }
        if (blockState.method_26164(Tags.LECTERNS) && BookshelfInspectorClient.config.lecternToggle) {
            this.lecternInspect(pos);
            return;
        }
        if (blockState.method_26164(Tags.SHELVES) && BookshelfInspectorClient.config.shelfToggle) {
            this.shelfInspect(pos, blockHitResult, client);
            return;
        }
        BookshelfInspectorClient.bookShelfData.requestSent = false;
        if (!BookshelfInspectorClient.bookShelfData.isCurrentBookDataToggled) {
            return;
        }
        this.resetBookShelfData();
    }

    private void lecternInspect(class_2338 pos) {
        BookData currentBookData = BookshelfInspectorClient.currentBookData;
        if (currentBookData.pos != null && currentBookData.pos.equals((Object)pos)) {
            return;
        }
        if (!BookshelfInspectorClient.bookShelfData.requestSent) {
            BookshelfInspectorClient.bookShelfData.requestSent = true;
            Services.NETWORK_HELPER.sendPacketFromClient(new LecternInventoryRequestPayload(pos));
        }
    }

    private void bookShelfInspect(class_2338 pos, class_3965 blockHitResult, class_310 client) {
        int slotNum;
        class_2680 blockState = client.field_1724.method_73183().method_8320(pos);
        class_7714 bookshelfBlock = (class_7714)blockState.method_26204();
        OptionalInt optionalInt = bookshelfBlock.method_72611(blockHitResult, (class_2350)blockState.method_11654((class_2769)class_7714.field_61990));
        if (optionalInt.isEmpty()) {
            this.resetBookShelfData();
            return;
        }
        BookData currentBookData = BookshelfInspectorClient.currentBookData;
        int temp = BookshelfInspectorClient.bookShelfData.currentSlotInt;
        BookshelfInspectorClient.bookShelfData.currentSlotInt = slotNum = optionalInt.getAsInt();
        if (currentBookData.slotId != slotNum && currentBookData.slotId != -2 && !BookshelfInspectorClient.bookShelfData.requestSent) {
            BookshelfInspectorClient.bookShelfData.requestSent = true;
            Services.NETWORK_HELPER.sendPacketFromClient(new BookShelfInventoryRequestPayload(pos, slotNum));
        } else if (temp == slotNum) {
            BookshelfInspectorClient.bookShelfData.isCurrentBookDataToggled = currentBookData.slotId != -2;
        } else {
            BookshelfInspectorClient.bookShelfData.isCurrentBookDataToggled = false;
            BookshelfInspectorClient.currentBookData = BookData.empty();
        }
    }

    private void shelfInspect(class_2338 pos, class_3965 blockHitResult, class_310 client) {
        int slotNum;
        class_2680 blockState = client.field_1724.method_73183().method_8320(pos);
        class_11586 shelfBlock = (class_11586)blockState.method_26204();
        OptionalInt optionalInt = shelfBlock.method_72611(blockHitResult, (class_2350)blockState.method_11654((class_2769)class_11586.field_61425));
        if (optionalInt.isEmpty()) {
            this.resetBookShelfData();
            return;
        }
        BookData currentBookData = BookshelfInspectorClient.currentBookData;
        int temp = BookshelfInspectorClient.bookShelfData.currentSlotInt;
        BookshelfInspectorClient.bookShelfData.currentSlotInt = slotNum = optionalInt.getAsInt();
        if (currentBookData.slotId != slotNum && !BookshelfInspectorClient.bookShelfData.requestSent) {
            BookshelfInspectorClient.bookShelfData.requestSent = true;
            Services.NETWORK_HELPER.sendPacketFromClient(new ShelfInventoryRequestPayload(pos, slotNum));
        } else if (temp == slotNum) {
            BookshelfInspectorClient.bookShelfData.isCurrentBookDataToggled = currentBookData.slotId != -2;
        } else {
            BookshelfInspectorClient.bookShelfData.isCurrentBookDataToggled = false;
            BookshelfInspectorClient.currentBookData = BookData.empty();
        }
    }

    private void resetBookShelfData() {
        if (!BookshelfInspectorClient.bookShelfData.isCurrentBookDataToggled) {
            return;
        }
        BookshelfInspectorClient.bookShelfData.isCurrentBookDataToggled = false;
        BookshelfInspectorClient.currentBookData = BookData.empty();
    }
}

