/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.util;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8800;
import org.apache.commons.validator.routines.UrlValidator;

public class ValidationUtils {
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(new String[]{"http", "https"});

    public static boolean isValidPngFilePath(String pathStr) {
        Path path;
        if (((String)(pathStr = ((String)pathStr).trim())).startsWith("\"") && ((String)pathStr).endsWith("\"")) {
            pathStr = ((String)pathStr).substring(1, ((String)pathStr).length() - 1);
        }
        if (((String)pathStr).startsWith("~")) {
            String home = System.getProperty("user.home");
            pathStr = home + ((String)pathStr).substring(1);
        }
        if (Files.exists(path = Paths.get((String)pathStr, new String[0]), new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            String fileName = path.getFileName().toString().toLowerCase();
            if (!fileName.endsWith(".png")) {
                return false;
            }
            try {
                class_8800 metadata = class_8800.method_53877((InputStream)Files.newInputStream(path, new OpenOption[0]));
                int width = metadata.comp_1965();
                int height = metadata.comp_1966();
                return width == 64 && (height == 64 || height == 32);
            }
            catch (Exception ignored) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidUUID(String uuid) {
        try {
            UUID.fromString(uuid);
            return true;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public static boolean isValidUsername(String username) {
        return username.matches("([a-zA-Z0-9]|_)*") && username.length() >= 3 && username.length() <= 16;
    }

    public static boolean isValidUrl(String url) {
        return URL_VALIDATOR.isValid(url);
    }

    public static boolean isValidResourceLocation(String location, class_310 client) {
        if (class_2960.method_29186((String)location).isSuccess()) {
            return client.method_1478().method_14486(class_2960.method_12829((String)location)).isPresent();
        }
        return false;
    }

    public static String normalizeFilePath(String path) {
        if (path == null) {
            return null;
        }
        if (((String)(path = ((String)path).trim())).startsWith("\"") && ((String)path).endsWith("\"")) {
            path = ((String)path).substring(1, ((String)path).length() - 1);
        }
        if (((String)path).startsWith("~")) {
            String home = System.getProperty("user.home");
            path = home + ((String)path).substring(1);
        }
        return path;
    }
}

