/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.skin;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.imb11.skinshuffle.MixinStatics;
import dev.imb11.skinshuffle.client.skin.ConfigSkin;
import dev.imb11.skinshuffle.client.skin.FileSkin;
import dev.imb11.skinshuffle.client.skin.ResourceSkin;
import dev.imb11.skinshuffle.client.skin.UUIDSkin;
import dev.imb11.skinshuffle.client.skin.UrlSkin;
import dev.imb11.skinshuffle.client.skin.UsernameSkin;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1068;
import net.minecraft.class_12079;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;

public interface Skin {
    public static final Map<class_2960, MapCodec<? extends Skin>> TYPES = Map.of(UrlSkin.SERIALIZATION_ID, UrlSkin.CODEC, ResourceSkin.SERIALIZATION_ID, ResourceSkin.CODEC, ConfigSkin.SERIALIZATION_ID, ConfigSkin.CODEC, FileSkin.SERIALIZATION_ID, FileSkin.CODEC, UsernameSkin.SERIALIZATION_ID, UsernameSkin.CODEC, UUIDSkin.SERIALIZATION_ID, UUIDSkin.CODEC);
    public static final Codec<Skin> CODEC = class_2960.field_25139.dispatch("type", Skin::getSerializationId, TYPES::get);

    public static ResourceSkin randomDefaultSkin() {
        UUID uuid = UUID.randomUUID();
        class_8685 txt = class_1068.method_4648((UUID)uuid);
        return new ResourceSkin(txt.comp_1626().comp_3627(), txt.comp_1629().name());
    }

    @Nullable
    public class_12079.class_12081 getTextureAsset();

    public class_2960 getTexture();

    default public class_8685 getSkinTextures() {
        class_310 client = class_310.method_1551();
        CompletableFuture<Optional<class_8685>> textureSupplier = client.method_1582().method_52863(client.method_53462());
        CompletableFuture<Optional<class_8685>> clientTexture = MixinStatics.INITIAL_SKIN_TEXTURES.isDone() ? MixinStatics.INITIAL_SKIN_TEXTURES.join() : textureSupplier;
        try {
            return new class_8685(this.getTextureAsset(), clientTexture.get().get().comp_1627(), clientTexture.get().get().comp_1628(), this.getModelEnum(), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public class_7920 getModelEnum() {
        String modelString = this.getModel();
        if (modelString == null) {
            return class_7920.field_41123;
        }
        return switch (modelString.toLowerCase()) {
            case "slim" -> {
                class_7920 var4_4;
                yield var4_4 = class_7920.field_41122;
            }
            case "classic", "wide", "default" -> {
                class_7920 var4_5;
                yield var4_5 = class_7920.field_41123;
            }
            default -> {
                try {
                    class_7920 var4_6;
                    yield var4_6 = class_7920.valueOf((String)modelString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    class_7920 var4_7;
                    yield var4_7 = class_7920.field_41123;
                }
            }
        };
    }

    public boolean isLoading();

    public String getModel();

    public void setModel(String var1);

    public class_2960 getSerializationId();

    public ConfigSkin saveToConfig();
}

