/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.preset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.skinshuffle.api.MojangSkinAPI;
import dev.imb11.skinshuffle.api.data.SkinQueryResult;
import dev.imb11.skinshuffle.client.skin.ResourceSkin;
import dev.imb11.skinshuffle.client.skin.Skin;
import dev.imb11.skinshuffle.client.skin.UrlSkin;
import dev.imb11.skinshuffle.util.NetworkingUtil;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_8685;

public class SkinPreset {
    public static final Codec<SkinPreset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Skin.CODEC.fieldOf("skin").forGetter(SkinPreset::getSkin), (App)Codec.STRING.fieldOf("name").forGetter(SkinPreset::getName), (App)Codec.INT.optionalFieldOf("keybindId", (Object)-1).forGetter(SkinPreset::getKeybindId)).apply((Applicative)instance, SkinPreset::new));
    private String name;
    private Skin skin;
    private int keybindId;

    public SkinPreset(Skin skin) {
        this(skin, "Unnamed Preset", -1);
    }

    public SkinPreset(Skin skin, String name) {
        this(skin, name, -1);
    }

    public SkinPreset(Skin skin, String name, int keybindId) {
        this.skin = skin;
        this.name = name;
        this.keybindId = keybindId;
    }

    public static SkinPreset generateDefaultPreset() {
        class_310 client = class_310.method_1551();
        class_320 session = client.method_1548();
        String name = session.method_1676();
        if (!NetworkingUtil.isLoggedIn()) {
            ResourceSkin skin = new ResourceSkin(class_2960.method_60654((String)"minecraft:textures/entity/player/wide/steve.png"), "default");
            return new SkinPreset(skin, name, -1);
        }
        SkinQueryResult skinQueryResult = MojangSkinAPI.getPlayerSkinTexture(String.valueOf(client.method_53462().id()));
        if (skinQueryResult.usesDefaultSkin()) {
            class_1071 provider = client.method_1582();
            if (provider == null) {
                return new SkinPreset(new ResourceSkin(class_2960.method_60654((String)"minecraft:textures/entity/player/wide/steve.png"), "default"));
            }
            class_8685 skinTexture = (class_8685)provider.method_73544(client.method_53462(), false).get();
            ResourceSkin skin = new ResourceSkin(skinTexture.comp_1626().comp_3627(), skinTexture.comp_1629().name());
            return new SkinPreset(skin, name, -1);
        }
        try (UrlSkin urlSkin = new UrlSkin(skinQueryResult.skinURL(), skinQueryResult.modelType());){
            SkinPreset skinPreset = new SkinPreset(urlSkin.saveToConfig(), name, -1);
            return skinPreset;
        }
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getKeybindId() {
        return this.keybindId;
    }

    public void setKeybindId(int keybindId) {
        this.keybindId = keybindId;
    }

    public void copyFrom(SkinPreset other) {
        this.name = other.name;
        this.skin = other.skin;
        this.keybindId = other.keybindId;
    }

    public SkinPreset copy() {
        return new SkinPreset(this.skin, this.name, this.keybindId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkinPreset that = (SkinPreset)o;
        if (this.keybindId != that.keybindId) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.skin.equals(that.skin);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.skin.hashCode();
        result = 31 * result + this.keybindId;
        return result;
    }
}

