/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.gui.widgets.presets;

import dev.imb11.skinshuffle.client.config.SkinPresetManager;
import dev.imb11.skinshuffle.client.config.SkinShuffleConfig;
import dev.imb11.skinshuffle.client.gui.PresetEditScreen;
import dev.imb11.skinshuffle.client.gui.carousels.CarouselScreen;
import dev.imb11.skinshuffle.client.gui.renderer.SkinPreviewRenderer;
import dev.imb11.skinshuffle.client.gui.widgets.buttons.VariableButton;
import dev.imb11.skinshuffle.client.gui.widgets.presets.AbstractCardWidget;
import dev.imb11.skinshuffle.client.preset.SkinPreset;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_8030;

public abstract class PresetWidget<S extends CarouselScreen>
extends AbstractCardWidget<S> {
    protected final SkinPreset skinPreset;
    private final boolean showButtons;
    private final SkinPreviewRenderer renderer;
    protected VariableButton editButton;
    protected VariableButton copyButton;
    protected VariableButton deleteButton;
    protected double scaleFactor;

    public PresetWidget(S parent, SkinPreset skinPreset) {
        super(Position.of((int)0, (int)0), ((CarouselScreen)((Object)parent)).getCardWidth(), ((CarouselScreen)((Object)parent)).getCardHeight(), parent);
        this.skinPreset = skinPreset;
        this.skinPreset.getSkin().getTexture();
        this.renderer = new SkinPreviewRenderer(this.client);
        this.showButtons = true;
        if (this.showButtons) {
            this.editButton = new VariableButton(Position.of((int)0, (int)0), 0, 0, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.preset_widget.edit"), button -> this.client.method_1507((class_437)new PresetEditScreen(this, this.parent, this.skinPreset)));
            this.copyButton = new VariableButton(Position.of((int)0, (int)0), 0, 0, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.preset_widget.copy"), button -> {
                SkinPreset presetCopy = this.skinPreset.copy();
                presetCopy.setName(this.skinPreset.getName() + " (Copy)");
                SkinPresetManager.addPreset(presetCopy);
                this.parent.refresh();
            });
            this.deleteButton = new VariableButton(Position.of((int)0, (int)0), 0, 0, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.preset_widget.delete"), button -> {
                class_410 confirmScreen = new class_410(result -> {
                    if (result) {
                        SkinPresetManager.deletePreset(this.skinPreset);
                    }
                    this.parent.refresh();
                    this.client.method_1507((class_437)this.parent);
                }, (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.confirmations.delete_preset.title"), (class_2561)class_2561.method_43471((String)"skinshuffle.carousel.confirmations.delete_preset.message"));
                this.client.method_1507((class_437)confirmScreen);
            });
            if (SkinPresetManager.getLoadedPresets().size() < 2) {
                this.deleteButton.setActive(false);
            }
            this.addChild((SpruceWidget)this.deleteButton);
            this.addChild((SpruceWidget)this.editButton);
            this.addChild((SpruceWidget)this.copyButton);
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        for (SpruceWidget child : this.children()) {
            if (child.equals((Object)this.deleteButton) && SkinPresetManager.getLoadedPresets().size() < 2) continue;
            child.setActive(active);
        }
    }

    protected void renderBackground(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int borderColour;
        int n = borderColour = this.active ? -553648128 : 0x5F000000;
        if (SkinPresetManager.getChosenPreset().equals(this.skinPreset)) {
            borderColour = this.active ? -553609473 : 1593874175;
        } else if (SkinPresetManager.getApiPreset() != null && SkinPresetManager.getApiPreset().equals(this.skinPreset)) {
            borderColour = this.active ? -553582848 : 0x5F00FF00;
        }
        this.drawBorder(graphics.vanilla(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), borderColour);
        graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, this.active ? 0x7F000000 : 0xD000000);
    }

    public void drawBorder(class_332 context, int x, int y, int width, int height, int color) {
        context.method_25294(x, y, x + width, y + 1, color);
        context.method_25294(x, y + height - 1, x + width, y + height, color);
        context.method_25294(x, y + 1, x + 1, y + height - 1, color);
        context.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderWidget(graphics, mouseX, mouseY, delta);
        Objects.requireNonNull(this.client.field_1772);
        int margin = 9 / 2;
        String name = this.skinPreset.getName() != null ? this.skinPreset.getName() : "Unnamed Preset";
        int nameWidth = this.client.field_1772.method_1727(name);
        int halfWidth = this.width / 2;
        int halfNameWidth = nameWidth / 2;
        class_332 class_3322 = graphics.vanilla();
        class_327 class_3272 = this.client.field_1772;
        class_2561 class_25612 = class_2561.method_30163((String)name);
        int n = this.getX() + halfWidth - Math.min(halfWidth - margin, halfNameWidth);
        int n2 = this.getY() + margin;
        int n3 = this.getX() + halfWidth + Math.min(halfWidth - margin, halfNameWidth);
        int n4 = this.getY() + margin;
        Objects.requireNonNull(this.client.field_1772);
        class_339.method_52718((class_332)class_3322, (class_327)class_3272, (class_2561)class_25612, (int)n, (int)n2, (int)n3, (int)(n4 + 9), (int)(this.active ? -1 : -8355712));
        SkinShuffleConfig.SkinRenderStyle renderStyle = SkinShuffleConfig.get().carouselSkinRenderStyle;
        int[] bounds = this.getPreviewBounds();
        int x1 = bounds[0];
        int y1 = bounds[1];
        int x2 = bounds[2];
        int y2 = bounds[3];
        this.renderer.renderSkinPreview(graphics.vanilla(), this.skinPreset, mouseX, mouseY, x1, y1, x2, y2, this.getPreviewScaling(), renderStyle, false);
    }

    protected abstract float getPreviewScaling();

    protected abstract int[] getPreviewBounds();

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public SkinPreset getPreset() {
        return this.skinPreset;
    }

    public class_8030 method_48202() {
        return super.method_48202();
    }

    @Override
    public void refreshState() {
        super.refreshState();
    }

    @Override
    public boolean isMovable() {
        return true;
    }
}

