/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.api;

import com.google.gson.Gson;
import dev.imb11.skinshuffle.api.data.SkinQueryResult;
import dev.imb11.skinshuffle.api.data.SkinUploadRequest;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class SkinShuffleAPI {
    private final String websocketHost;
    private final Gson gson = new Gson();
    private final HttpClient httpClient = HttpClient.newHttpClient();

    public SkinShuffleAPI(String websocketHost) {
        this.websocketHost = websocketHost;
    }

    private URI buildUri() {
        return URI.create("wss://" + this.websocketHost + "/skin-gateway");
    }

    private CompletableFuture<SkinQueryResult> connectAndSend(final String jsonMessage, final byte[] binaryData) {
        URI uri = this.buildUri();
        final CompletableFuture<SkinQueryResult> futureResult = new CompletableFuture<SkinQueryResult>();
        WebSocket.Listener listener = new WebSocket.Listener(){

            @Override
            public void onOpen(WebSocket webSocket) {
                if (binaryData != null) {
                    webSocket.sendBinary(ByteBuffer.wrap(binaryData), true);
                }
                webSocket.sendText(jsonMessage, true);
                WebSocket.Listener.super.onOpen(webSocket);
            }

            public CompletableFuture<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                String message = data.toString();
                try {
                    SkinQueryResult result = (SkinQueryResult)SkinShuffleAPI.this.gson.fromJson(message, SkinQueryResult.class);
                    futureResult.complete(result);
                }
                catch (Exception e) {
                    futureResult.completeExceptionally(e);
                }
                return (CompletableFuture)WebSocket.Listener.super.onText(webSocket, data, last);
            }

            @Override
            public void onError(WebSocket webSocket, Throwable error) {
                futureResult.completeExceptionally(error);
                WebSocket.Listener.super.onError(webSocket, error);
            }

            public CompletableFuture<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                if (!futureResult.isDone()) {
                    futureResult.completeExceptionally(new RuntimeException("Connection closed prematurely: " + reason));
                }
                return (CompletableFuture)WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
            }
        };
        CompletableFuture<WebSocket> wsFuture = this.httpClient.newWebSocketBuilder().connectTimeout(Duration.ofSeconds(10L)).buildAsync(uri, listener);
        wsFuture.thenAccept(ws -> futureResult.whenComplete((result, error) -> ws.sendClose(1000, "Done").join()));
        return futureResult;
    }

    public SkinQueryResult uploadUrlSkin(String skinUrl, String model) throws Exception {
        SkinUploadRequest request = new SkinUploadRequest("url", skinUrl, model);
        String jsonMessage = this.gson.toJson((Object)request);
        return this.connectAndSend(jsonMessage, null).get(30L, TimeUnit.SECONDS);
    }

    public SkinQueryResult uploadFileSkin(Path filePath, String model) throws Exception {
        byte[] fileBytes = Files.readAllBytes(filePath);
        SkinUploadRequest request = new SkinUploadRequest("file", null, model);
        String jsonMessage = this.gson.toJson((Object)request);
        return this.connectAndSend(jsonMessage, fileBytes).get(30L, TimeUnit.SECONDS);
    }
}

