/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle;

import com.mojang.authlib.GameProfile;
import dev.imb11.skinshuffle.MixinStatics;
import dev.imb11.skinshuffle.api.MojangSkinAPI;
import dev.imb11.skinshuffle.api.data.SkinQueryResult;
import dev.imb11.skinshuffle.compat.api.CompatLoader;
import dev.imb11.skinshuffle.networking.HandshakePayload;
import dev.imb11.skinshuffle.networking.RefreshPlayerListEntryPayload;
import dev.imb11.skinshuffle.networking.ServerSkinHandling;
import dev.imb11.skinshuffle.networking.SkinRefreshPayload;
import dev.imb11.skinshuffle.util.SkinCacheRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8685;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinShuffle
implements ModInitializer {
    public static final String MOD_ID = "skinshuffle";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"skinshuffle");
    public static final Path DATA_DIR = FabricLoader.getInstance().getConfigDir().resolve("skinshuffle");

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void onInitialize() {
        PayloadTypeRegistry.playC2S().register(SkinRefreshPayload.PACKET_ID, SkinRefreshPayload.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(HandshakePayload.PACKET_ID, class_9139.method_56431((Object)HandshakePayload.INSTANCE));
        PayloadTypeRegistry.playS2C().register(RefreshPlayerListEntryPayload.PACKET_ID, RefreshPlayerListEntryPayload.PACKET_CODEC);
        this.ensureDataDir();
        SkinCacheRegistry.initialize();
        ServerSkinHandling.init();
        CompatLoader.init();
        MixinStatics.INITIAL_SKIN_TEXTURES = CompletableFuture.supplyAsync(this::getInitialSkinTextures);
    }

    private CompletableFuture<Optional<class_8685>> getInitialSkinTextures() {
        while (class_310.method_1551() == null) {
            Thread.onSpinWait();
        }
        while (class_310.method_1551().method_1582() == null) {
            Thread.onSpinWait();
        }
        class_310 client = class_310.method_1551();
        try {
            assert (client != null);
            SkinQueryResult tex = MojangSkinAPI.getPlayerSkinTexture(String.valueOf(client.method_53462().id()));
            GameProfile dummyProfile = new GameProfile(UUID.randomUUID(), "dummyname");
            return client.method_1582().method_52863(dummyProfile);
        }
        catch (Exception error) {
            LOGGER.error("Failed to fetch initial skin textures from Mojang's API.", (Throwable)error);
            return client.method_1582().method_52863(client.method_53462());
        }
    }

    private void ensureDataDir() {
        if (!DATA_DIR.toFile().exists()) {
            try {
                Files.createDirectories(DATA_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create " + String.valueOf(DATA_DIR), e);
            }
        }
    }
}

