/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.status.playerstate;

import de.maxhenkel.status.StatusClient;
import de.maxhenkel.status.events.ClientWorldEvents;
import de.maxhenkel.status.net.PlayerStatePacket;
import de.maxhenkel.status.net.PlayerStatesPacket;
import de.maxhenkel.status.playerstate.Availability;
import de.maxhenkel.status.playerstate.PlayerState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;

public class ClientPlayerStateManager {
    private PlayerState state = this.getDefaultState();
    private boolean stateChanged;
    private Map<UUID, PlayerState> states = new HashMap<UUID, PlayerState>();
    private static final class_2960 DND = class_2960.method_60655((String)"status", (String)"textures/icons/dnd.png");
    private static final class_2960 OPEN = class_2960.method_60655((String)"status", (String)"textures/icons/open.png");
    private static final class_2960 NO_AVAILABILITY = class_2960.method_60655((String)"status", (String)"textures/icons/no_availability.png");
    private static final class_2960 RECORDING = class_2960.method_60655((String)"status", (String)"textures/icons/recording.png");
    private static final class_2960 STREAMING = class_2960.method_60655((String)"status", (String)"textures/icons/streaming.png");
    private static final class_2960 NEUTRAL = class_2960.method_60655((String)"status", (String)"textures/icons/neutral.png");

    public ClientPlayerStateManager() {
        ClientPlayNetworking.registerGlobalReceiver(PlayerStatePacket.PLAYER_STATE, (packet, context) -> this.states.put(packet.getPlayerState().getPlayer(), packet.getPlayerState()));
        ClientPlayNetworking.registerGlobalReceiver(PlayerStatesPacket.PLAYER_STATES, (packet, context) -> {
            this.states = packet.getPlayerStates();
        });
        ClientWorldEvents.DISCONNECT.register(this::onDisconnect);
        ClientWorldEvents.JOIN_SERVER.register(this::onConnect);
    }

    public String getState() {
        return this.state.getState();
    }

    public void setState(String s) {
        this.state.setState(s);
        this.syncOwnState();
        StatusClient.CLIENT_CONFIG.status.set(s);
        StatusClient.CLIENT_CONFIG.status.save();
        this.stateChanged = true;
    }

    public void setAvailability(Availability availability) {
        this.state.setAvailability(availability);
        this.syncOwnState();
        StatusClient.CLIENT_CONFIG.availability.set(availability);
        StatusClient.CLIENT_CONFIG.availability.save();
        this.stateChanged = true;
    }

    public Availability getAvailabilityIcon() {
        return this.state.getAvailability();
    }

    public boolean getNoSleep() {
        return this.state.isNoSleep();
    }

    public void setNoSleep(boolean noSleep) {
        this.state.setNoSleep(noSleep);
        this.syncOwnState();
        StatusClient.CLIENT_CONFIG.noSleep.set(noSleep);
        StatusClient.CLIENT_CONFIG.noSleep.save();
        this.stateChanged = true;
    }

    private PlayerState getDefaultState() {
        if (StatusClient.CLIENT_CONFIG.persistState.get().booleanValue()) {
            return new PlayerState(class_310.method_1551().method_1548().method_44717(), StatusClient.CLIENT_CONFIG.availability.get(), StatusClient.CLIENT_CONFIG.status.get(), StatusClient.CLIENT_CONFIG.noSleep.get());
        }
        return new PlayerState(class_310.method_1551().method_1548().method_44717());
    }

    private void onDisconnect() {
        this.clearStates();
    }

    private void onConnect() {
        this.syncOwnState();
        if (StatusClient.CLIENT_CONFIG.showJoinMessage.get().booleanValue() && !this.stateChanged) {
            this.showChangeStatusMessage();
        }
    }

    private void showChangeStatusMessage() {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2564.method_10885((class_2561)class_2561.method_43471((String)"message.status.mod_name")).method_27692(class_124.field_1060).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"message.status.change_status").method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"message.status.set_status")))).method_27692(class_124.field_1068)));
    }

    public void syncOwnState() {
        ClientPlayNetworking.send((class_8710)new PlayerStatePacket(this.state));
    }

    @Nullable
    public PlayerState getState(UUID player) {
        if (player.equals(class_310.method_1551().field_1724.method_7334().id())) {
            return this.state;
        }
        return this.states.get(player);
    }

    @Nullable
    public class_2960 getActivityIcon(UUID player) {
        PlayerState state = this.getState(player);
        if (state == null) {
            return null;
        }
        if (state.getState().equals("recording")) {
            return RECORDING;
        }
        if (state.getState().equals("streaming")) {
            return STREAMING;
        }
        return NEUTRAL;
    }

    @Nullable
    public class_2960 getAvailabilityIcon(UUID player) {
        PlayerState state = this.getState(player);
        if (state == null) {
            return null;
        }
        if (state.getAvailability().equals((Object)Availability.DO_NOT_DISTURB)) {
            return DND;
        }
        if (state.getAvailability().equals((Object)Availability.OPEN)) {
            return OPEN;
        }
        return NO_AVAILABILITY;
    }

    public void clearStates() {
        this.states.clear();
    }
}

