/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.mixin.client;

import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.cache.ShulkerBoxBlockEntityEntry;
import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformationMap;
import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformations;
import com.steveh259.shulkerboxlabels.common.ducks.IShulkerBoxRenderState;
import com.steveh259.shulkerboxlabels.common.ducks.IShulkerBoxRenderer;
import com.steveh259.shulkerboxlabels.common.render.LabelRenderer;
import com.steveh259.shulkerboxlabels.common.render.utils.RenderBypass;
import com.steveh259.shulkerboxlabels.common.render.utils.RenderUtils;
import com.steveh259.shulkerboxlabels.common.utils.DebugUtils;
import java.util.EnumSet;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11970;
import net.minecraft.class_12075;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2627;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_834;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_834.class})
public class ShulkerBoxRendererMixin
implements IShulkerBoxRenderer {
    @Unique
    private class_811 itemDisplayContext;
    @Unique
    private class_1799 parent;
    @Unique
    private class_1799 label;
    @Unique
    private class_2350 blockFacing = class_2350.field_11036;
    @Unique
    private class_2350 labelFacing = class_2350.field_11043;
    @Unique
    private class_2627 currentShulkerBoxBlockEntity = null;
    @Unique
    private float overriddenOpenness = -1.0f;

    @Inject(method={"method_74384(Lnet/minecraft/class_2627;Lnet/minecraft/class_11970;FLnet/minecraft/class_243;Lnet/minecraft/class_11683$class_11792;)V"}, at={@At(value="HEAD")})
    private void beforeExtractRenderState(class_2627 be, class_11970 shulkerBoxRenderState, float f, class_243 vec3, class_11683.class_11792 crumblingOverlay, CallbackInfo ci) {
        ((IShulkerBoxRenderState)shulkerBoxRenderState).shulker_box_labels$setBlockEntity(be);
    }

    @Unique
    private void setLocalVariables(@Nullable ShulkerBoxBlockEntityEntry cacheItem, class_2627 be) {
        if (cacheItem == null) {
            this.label = null;
            this.blockFacing = null;
            this.labelFacing = null;
            this.itemDisplayContext = null;
            this.currentShulkerBoxBlockEntity = null;
        } else {
            this.label = cacheItem.label;
            this.blockFacing = cacheItem.blockFacing;
            this.labelFacing = cacheItem.labelFacing;
            this.itemDisplayContext = class_811.field_4319;
            this.currentShulkerBoxBlockEntity = be;
        }
    }

    @Inject(method={"method_3574(Lnet/minecraft/class_11970;Lnet/minecraft/class_4587;Lnet/minecraft/class_11659;Lnet/minecraft/class_12075;)V"}, at={@At(value="HEAD")})
    private void onFirstSubmit(class_11970 shulkerBoxRenderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
        class_2627 be = ((IShulkerBoxRenderState)shulkerBoxRenderState).shulker_box_labels$getBlockEntity();
        ((IShulkerBoxRenderState)shulkerBoxRenderState).shulker_box_labels$setBlockEntity(null);
        ShulkerBoxBlockEntityEntry cacheItem = LabelRenderer.updateBlockEntityCache(be);
        this.setLocalVariables(cacheItem, be);
    }

    @Inject(method={"method_65562(Lnet/minecraft/class_4587;Lnet/minecraft/class_11659;IILnet/minecraft/class_2350;FLnet/minecraft/class_11683$class_11792;Lnet/minecraft/class_4730;I)V"}, at={@At(value="HEAD")})
    public void onSecondRender(class_4587 matrices, class_11659 submitNodeCollector, int light, int overlay, class_2350 direction, float openness, class_11683.class_11792 crumblingOverlay, class_4730 material, int k, CallbackInfo ci) {
        class_10444 itemRenderState;
        float specificScale;
        boolean isBlock;
        CustomItemTransformations customTransformations;
        boolean iso;
        if (this.itemDisplayContext == null) {
            return;
        }
        RenderBypass bypass = RenderBypass.fromLabelItemStack(this.label);
        boolean gui = bypass == null && this.itemDisplayContext.equals((Object)class_811.field_4317) || bypass != null && bypass.isGui();
        boolean flat = bypass == null && ((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("enabled") || bypass == null && ((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("onlyLabeled") && this.label != null && !this.label.method_7960() || bypass != null && bypass.isFlat();
        boolean flatLarge = bypass == null && (Boolean)CommonClient.config.renderFlatLarge.get() != false || bypass != null && bypass.isFlatLarge();
        boolean bl = iso = bypass == null && RenderUtils.renderIso(this.itemDisplayContext) || bypass != null && bypass.isIso();
        if (bypass != null) {
            openness = bypass.getRotation();
            this.overriddenOpenness = bypass.getRotation();
        }
        if (gui && flat) {
            RenderUtils.translateShulkerBoxFlat(flatLarge, matrices);
        }
        if (bypass == null && !((Boolean)CommonClient.config.renderLabels.get()).booleanValue()) {
            return;
        }
        if (this.label == null || this.label.method_7960()) {
            return;
        }
        if (EnumSet.of(class_2350.field_11036, class_2350.field_11033).contains(this.blockFacing) && this.labelFacing == null) {
            return;
        }
        ShulkerBoxBlockEntityEntry cacheItem = CommonClient.cache.getShulkerBoxBlockEntityEntry(this.currentShulkerBoxBlockEntity);
        if (DebugUtils.isDebugMode() && (float)class_7923.field_41178.method_10206((Object)this.label.method_7909()) == DebugUtils.getValue("itemIndex") || cacheItem == null || cacheItem.customItemTransformations == null || !cacheItem.worldRenderingMode.equalsIgnoreCase((String)CommonClient.config.labelRenderingModeWorld.get())) {
            customTransformations = CustomItemTransformationMap.getItemTransformation(this.label.method_7909());
            isBlock = RenderUtils.isBlock(this.label.method_7909(), customTransformations);
            specificScale = RenderUtils.getScale(this.itemDisplayContext, this.label.method_7909(), bypass);
            if (cacheItem != null) {
                cacheItem.customItemTransformations = customTransformations;
                cacheItem.isBlock = isBlock;
                cacheItem.scale = specificScale;
                if (!cacheItem.worldRenderingMode.equalsIgnoreCase((String)CommonClient.config.labelRenderingModeWorld.get())) {
                    cacheItem.label = null;
                    cacheItem.worldRenderingMode = (String)CommonClient.config.labelRenderingModeWorld.get();
                }
            }
        } else {
            customTransformations = cacheItem.customItemTransformations;
            isBlock = cacheItem.isBlock;
            specificScale = cacheItem.scale;
        }
        float scale = 1.0f;
        if (!iso) {
            scale = isBlock ? 2.0f : 1.0f;
        }
        scale *= specificScale;
        float rotationX = -90.0f;
        float rotationY = 0.0f;
        float rotationZ = 0.0f;
        if (bypass == null && ((Boolean)CommonClient.config.rotateLabel.get()).booleanValue() || bypass != null && bypass.shouldRotateLabel()) {
            rotationZ -= 270.0f * openness;
        }
        if (gui && !flat) {
            rotationZ -= 90.0f;
        }
        if (this.labelFacing != null && EnumSet.of(class_2350.field_11036, class_2350.field_11033).contains(this.blockFacing)) {
            rotationZ += (this.labelFacing.method_10144() - 180.0f) * (float)(this.blockFacing == class_2350.field_11036 ? -1 : 1);
        }
        matrices.method_22903();
        matrices.method_34425((Matrix4fc)new Matrix4f().rotate((Quaternionfc)this.blockFacing.method_23224()));
        matrices.method_46416(RenderUtils.getInitialTranslation(class_2350.class_2351.field_11048, this.blockFacing), RenderUtils.getInitialTranslation(class_2350.class_2351.field_11051, this.blockFacing), RenderUtils.getInitialTranslation(class_2350.class_2351.field_11052, this.blockFacing));
        matrices.method_34425((Matrix4fc)new Matrix4f().rotateXYZ((float)Math.toRadians(rotationX), (float)Math.toRadians(rotationY), (float)Math.toRadians(rotationZ)));
        if (!iso) {
            RenderUtils.applyCustomTransformations(matrices, this.label, customTransformations, this.itemDisplayContext, specificScale, isBlock, openness, iso, bypass);
        } else {
            matrices.method_46416(0.0f, 0.0f, 0.008f + openness * 0.5f);
        }
        matrices.method_22905(scale, scale, iso ? 0.005f : scale);
        if (cacheItem == null || cacheItem.label == null || !class_1799.method_7973((class_1799)cacheItem.label, (class_1799)this.label)) {
            itemRenderState = new class_10444();
            this.forceBypassNestedShulkerBox();
            class_310.method_1551().method_65386().method_65598(itemRenderState, this.label, iso ? class_811.field_4317 : class_811.field_4319, (class_1937)class_310.method_1551().field_1687, null, 0);
            if (cacheItem != null) {
                cacheItem.label = this.label;
                cacheItem.customItemTransformations = null;
                cacheItem.labelItemRenderState = itemRenderState;
            }
        } else {
            itemRenderState = cacheItem.labelItemRenderState;
        }
        RenderUtils.fixLighting(matrices, itemRenderState, bypass, gui, flat, iso, customTransformations);
        if (!this.isLabelOfNestedShulkerbox(bypass)) {
            this.renderItemStackRenderState(itemRenderState, matrices, light, overlay, submitNodeCollector);
        }
        matrices.method_22909();
        this.currentShulkerBoxBlockEntity = null;
        this.parent = null;
        this.label = null;
    }

    @Unique
    private void renderItemStackRenderState(class_10444 itemStackRenderState, class_4587 poseStack, int light, int overlay, class_11659 submitNodeCollector) {
        itemStackRenderState.method_65604(poseStack, submitNodeCollector, light, overlay, 0);
    }

    @Unique
    private void forceBypassNestedShulkerBox() {
        if (this.label == null || this.label.method_7960()) {
            return;
        }
        if ((this.parent == null || this.parent.method_7960()) && this.currentShulkerBoxBlockEntity == null) {
            return;
        }
        class_1792 class_17922 = this.label.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return;
        }
        class_1747 labelBlockItem = (class_1747)class_17922;
        if (!(labelBlockItem.method_7711() instanceof class_2480)) {
            return;
        }
        if (this.currentShulkerBoxBlockEntity == null) {
            class_1792 class_17923 = this.parent.method_7909();
            if (!(class_17923 instanceof class_1747)) {
                return;
            }
            class_1747 parentBlockItem = (class_1747)class_17923;
            if (!(parentBlockItem.method_7711() instanceof class_2480)) {
                return;
            }
        }
        this.label = new RenderBypass().gui().toItemStack(labelBlockItem.method_7711(), class_1802.field_30904);
    }

    @Unique
    private boolean isLabelOfNestedShulkerbox(RenderBypass bypass) {
        return bypass != null && this.label.method_7909().equals(class_1802.field_30904);
    }

    @ModifyArg(method={"method_65562(Lnet/minecraft/class_4587;Lnet/minecraft/class_11659;IILnet/minecraft/class_2350;FLnet/minecraft/class_11683$class_11792;Lnet/minecraft/class_4730;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_11659;method_73490(Lnet/minecraft/class_3879;Ljava/lang/Object;Lnet/minecraft/class_4587;Lnet/minecraft/class_1921;IIILnet/minecraft/class_1058;ILnet/minecraft/class_11683$class_11792;)V"), index=1)
    private Object overrideOpenness(Object original) {
        if (!(original instanceof Float)) {
            return original;
        }
        Float f = (Float)original;
        return Float.valueOf(this.opennessOverride(f.floatValue()));
    }

    @Unique
    private float opennessOverride(float original) {
        float returnVal = original;
        if (this.overriddenOpenness != -1.0f) {
            returnVal = this.overriddenOpenness;
        }
        this.overriddenOpenness = -1.0f;
        return returnVal;
    }

    @Override
    public void shulker_box_labels$setItemDisplayContext(class_811 itemDisplayContext) {
        this.itemDisplayContext = itemDisplayContext;
    }

    @Override
    public void shulker_box_labels$setItemStack(class_1799 itemStack) {
        this.label = itemStack;
    }

    @Override
    public void shulker_box_labels$setParent(class_1799 parent) {
        this.parent = parent;
    }

    @Override
    public class_1799 shulker_box_labels$getParent() {
        return this.parent;
    }
}

