/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.utils;

import com.steveh259.shulkerboxlabels.common.CommonClient;
import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformationMap;
import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformations;
import com.steveh259.shulkerboxlabels.common.ducks.IItemStackRenderState;
import com.steveh259.shulkerboxlabels.common.render.utils.RenderBypass;
import com.steveh259.shulkerboxlabels.common.utils.DebugUtils;
import com.steveh259.shulkerboxlabels.common.utils.LabelItemObject;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.class_10444;
import net.minecraft.class_11540;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Unique;

public class RenderUtils {
    private static boolean isDebug(class_1792 labelItem) {
        return DebugUtils.isDebugMode() && (float)class_7923.field_41178.method_10206((Object)labelItem) == DebugUtils.getValue("itemIndex");
    }

    public static float getScale(class_811 displayContext, class_1792 labelItem, RenderBypass bypass) {
        float scaleWorld;
        boolean debug = RenderUtils.isDebug(labelItem);
        CustomItemTransformations customTransformation = CustomItemTransformationMap.getItemTransformation(labelItem);
        boolean iso = bypass == null && RenderUtils.renderIso(displayContext) || bypass != null && bypass.isIso();
        CustomItemTransformations.Perspective perspective = RenderUtils.displayContextToPerspective(displayContext, bypass);
        if (perspective.equals((Object)CustomItemTransformations.Perspective.GUI)) {
            float scaleGUI;
            if (iso) {
                return 0.7f;
            }
            if (debug && (scaleGUI = DebugUtils.getValue("scaleGUI")) != 0.0f) {
                return scaleGUI;
            }
            scaleGUI = customTransformation.getScale(CustomItemTransformations.Perspective.GUI);
            if (scaleGUI != 0.0f) {
                return scaleGUI;
            }
            return 0.7f;
        }
        if (perspective.equals((Object)CustomItemTransformations.Perspective.FirstPersonHands)) {
            float scaleWorld2;
            if (iso) {
                return 0.5f;
            }
            if (debug && (scaleWorld2 = DebugUtils.getValue("scaleHands")) != 0.0f) {
                return scaleWorld2;
            }
            float scale = customTransformation.getScale(perspective);
            if (scale != 0.0f) {
                return scale;
            }
            return 0.5f;
        }
        if (iso) {
            return 0.5f;
        }
        if (debug && (scaleWorld = DebugUtils.getValue("scaleWorld")) != 0.0f) {
            return scaleWorld;
        }
        float scale = customTransformation.getScale(perspective);
        if (scale != 0.0f) {
            return scale;
        }
        return 0.5f;
    }

    public static boolean renderIso(class_811 displayContext) {
        return switch (displayContext) {
            case class_811.field_4323, class_811.field_4320, class_811.field_4321, class_811.field_4322 -> ((String)CommonClient.config.labelRenderingModeHands.get()).equalsIgnoreCase("iso");
            case class_811.field_4317 -> ((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso");
            default -> ((String)CommonClient.config.labelRenderingModeWorld.get()).equalsIgnoreCase("iso");
        };
    }

    private static CustomItemTransformations.Perspective displayContextToPerspective(class_811 itemDisplayContext, RenderBypass bypass) {
        if (bypass != null) {
            if (bypass.isGui()) {
                return CustomItemTransformations.Perspective.GUI;
            }
            return CustomItemTransformations.Perspective.World;
        }
        if (itemDisplayContext.method_29998()) {
            return CustomItemTransformations.Perspective.FirstPersonHands;
        }
        if (itemDisplayContext.equals((Object)class_811.field_4317)) {
            return CustomItemTransformations.Perspective.GUI;
        }
        return CustomItemTransformations.Perspective.World;
    }

    public static float getCustomTranslation(class_1792 labelItem, class_2350.class_2351 axis, CustomItemTransformations customItemTransformations, class_811 itemDisplayContext, RenderBypass bypass) {
        if (RenderUtils.isDebug(labelItem)) {
            return DebugUtils.getValue(String.format("translationOffset%sValue", axis.toString().toUpperCase()));
        }
        CustomItemTransformations.Perspective perspective = RenderUtils.displayContextToPerspective(itemDisplayContext, bypass);
        return customItemTransformations.getTranslation(axis, perspective, bypass);
    }

    public static float getCustomRotation(class_1792 labelItem, class_2350.class_2351 axis, CustomItemTransformations customItemTransformations, class_811 itemDisplayContext, RenderBypass bypass) {
        if (RenderUtils.isDebug(labelItem)) {
            return (float)Math.toRadians(DebugUtils.getValue(String.format("rotationOffset%sValue", axis.toString().toUpperCase())));
        }
        CustomItemTransformations.Perspective perspective = RenderUtils.displayContextToPerspective(itemDisplayContext, bypass);
        return (float)Math.toRadians(customItemTransformations.getRotation(axis, perspective, bypass));
    }

    public static boolean isBlock(class_1792 labelItem, CustomItemTransformations customItemTransformations) {
        if (RenderUtils.isDebug(labelItem) && DebugUtils.getValue("forceTreatAsBlock") == 1.0f) {
            return true;
        }
        if (labelItem instanceof class_1747) {
            class_1747 bi = (class_1747)labelItem;
            if (class_310.method_1551().field_1687 == null) {
                return true;
            }
            if (bi.method_7711().method_9564().method_26234((class_1922)class_310.method_1551().field_1687, new class_2338(0, 0, 0))) {
                return true;
            }
            return customItemTransformations.isTreatAsBlock();
        }
        return false;
    }

    public static float getBlockModelZOffset(class_1792 labelItem, CustomItemTransformations customItemTransformations, float scale, class_811 displayContext, boolean isBlockItem, boolean iso) {
        class_1747 blockItem;
        block9: {
            block8: {
                if (iso) {
                    return 0.001f;
                }
                if (RenderUtils.isDebug(labelItem) && DebugUtils.getValue("calculateBoundingBoxOffset") == 1.0f) {
                    return 0.0f;
                }
                if (!(labelItem instanceof class_1747)) break block8;
                blockItem = (class_1747)labelItem;
                if (isBlockItem && (!RenderUtils.isDebug(labelItem) || DebugUtils.getValue("forceTreatAsBlock") != 0.0f)) break block9;
            }
            return 0.015625f;
        }
        if (!customItemTransformations.shouldCalculateDynamicBlockOffset()) {
            return 0.0f;
        }
        if (class_310.method_1551().field_1687 == null) {
            return -(1.0f * scale) / 2.0f + 0.03125f;
        }
        class_265 shape = blockItem.method_7711().method_9564().method_26220((class_1922)class_310.method_1551().field_1687, new class_2338(0, 0, 0));
        float translationZ = 0.0f;
        if (!shape.method_1110()) {
            class_238 boundingBox = shape.method_1107();
            translationZ -= (float)(boundingBox.method_17941() * (double)scale) / 2.0f;
            translationZ += 0.03125f;
        }
        return translationZ;
    }

    public static float getInitialTranslation(class_2350.class_2351 axis, class_2350 blockFacing) {
        if (axis.equals((Object)class_2350.class_2351.field_11048)) {
            if (EnumSet.of(class_2350.field_11043, class_2350.field_11034).contains(blockFacing)) {
                return -0.5f;
            }
        } else if (axis.equals((Object)class_2350.class_2351.field_11052)) {
            if (!EnumSet.of(class_2350.field_11036).contains(blockFacing)) {
                return -0.5f;
            }
        } else if (axis.equals((Object)class_2350.class_2351.field_11051)) {
            if (EnumSet.of(class_2350.field_11036, class_2350.field_11035, class_2350.field_11034).contains(blockFacing)) {
                return 1.0f;
            }
            return 0.0f;
        }
        return 0.5f;
    }

    public static void translateShulkerBoxFlat(boolean flatLarge, class_4587 matrixStack) {
        float scale = 1.59375f * (flatLarge ? 1.0f : 0.8f);
        matrixStack.method_22904(0.5, 0.5, 0.5);
        matrixStack.method_22905(scale, scale, scale);
        matrixStack.method_22907((Quaternionfc)class_7833.field_40715.rotationDegrees(45.0f));
        matrixStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(60.0f));
        matrixStack.method_22904(-0.5, -0.5, -0.5);
    }

    public static void setIsoLighting(boolean gui, boolean flat, class_4587 matrixStack, class_10444 itemRenderState) {
        boolean sideLit = itemRenderState.method_65608();
        Matrix3f mat = new Matrix3f();
        if (sideLit) {
            mat.rotateXYZ((float)Math.toRadians(-30.0), (float)Math.toRadians(15.0), 0.0f);
            if (gui) {
                mat.rotateXYZ(0.0f, 0.0f, (float)Math.toRadians(-240.0));
            }
        } else if (!gui) {
            mat.rotateXYZ((float)Math.toRadians(-90.0), 0.0f, 0.0f);
        }
        if (gui && !flat) {
            mat.rotateXYZ(0.0f, (float)Math.toRadians(-60.0), 0.0f);
        }
        matrixStack.method_23760().method_23762().set((Matrix3fc)mat);
    }

    public static void applyCustomTransformations(class_4587 matrixStack, class_1799 label, CustomItemTransformations customTransformations, class_811 displayContext, float scale, boolean isBlock, float openness, boolean iso, RenderBypass bypass) {
        matrixStack.method_46416(RenderUtils.getCustomTranslation(label.method_7909(), class_2350.class_2351.field_11048, customTransformations, displayContext, bypass), RenderUtils.getCustomTranslation(label.method_7909(), class_2350.class_2351.field_11052, customTransformations, displayContext, bypass), RenderUtils.getCustomTranslation(label.method_7909(), class_2350.class_2351.field_11051, customTransformations, displayContext, bypass) + RenderUtils.getBlockModelZOffset(label.method_7909(), customTransformations, scale, displayContext, isBlock, iso) + openness * 0.5f);
        matrixStack.method_34425((Matrix4fc)new Matrix4f().rotateXYZ(RenderUtils.getCustomRotation(label.method_7909(), class_2350.class_2351.field_11048, customTransformations, displayContext, bypass), RenderUtils.getCustomRotation(label.method_7909(), class_2350.class_2351.field_11052, customTransformations, displayContext, bypass) + (float)Math.toRadians(180.0), RenderUtils.getCustomRotation(label.method_7909(), class_2350.class_2351.field_11051, customTransformations, displayContext, bypass)));
    }

    public static void fixLighting(class_4587 matrices, class_10444 itemRenderState, RenderBypass bypass, boolean gui, boolean flat, boolean iso, CustomItemTransformations customTransformations) {
        if (bypass == null && iso) {
            RenderUtils.setIsoLighting(gui, flat, matrices, itemRenderState);
        }
        if (bypass != null && iso) {
            matrices.method_23760().method_23762().set((Matrix3fc)new Matrix3f().rotateXYZ((float)Math.toRadians(112.0), (float)Math.toRadians(10.0), (float)Math.toRadians(0.0)));
        }
        if (!iso && (gui || bypass != null)) {
            CustomItemTransformations.Perspective guiPersp = CustomItemTransformations.Perspective.GUI;
            if (!flat) {
                matrices.method_23760().method_23762().set((Matrix3fc)new Matrix3f().rotateXYZ((float)Math.toRadians(-customTransformations.getRotation(class_2350.class_2351.field_11048, guiPersp) - 90.0f), (float)Math.toRadians(-customTransformations.getRotation(class_2350.class_2351.field_11052, guiPersp) + 90.0f), (float)Math.toRadians(-customTransformations.getRotation(class_2350.class_2351.field_11051, guiPersp) + 15.0f)));
            } else {
                matrices.method_23760().method_23762().set((Matrix3fc)new Matrix3f().rotateXYZ((float)Math.toRadians(-customTransformations.getRotation(class_2350.class_2351.field_11048, guiPersp) + 90.0f), (float)Math.toRadians(-customTransformations.getRotation(class_2350.class_2351.field_11052, guiPersp) + 120.0f), (float)Math.toRadians(-customTransformations.getRotation(class_2350.class_2351.field_11051, guiPersp) + 120.0f)));
            }
        }
    }

    public static int getTopHeightOverflow(class_11540 itemStackRenderState) {
        class_1792 labelItem = RenderUtils.getLabelItemFromModelKey(itemStackRenderState.method_72239());
        if (labelItem == null) {
            return 0;
        }
        if (DebugUtils.isDebugMode() && RenderUtils.isDebug(labelItem)) {
            return (int)DebugUtils.getValue("heightOverflow");
        }
        if (!((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("disabled")) {
            return 0;
        }
        if (((String)CommonClient.config.labelRenderingModeGUI.get()).equalsIgnoreCase("iso")) {
            return 0;
        }
        class_1799 label = ((IItemStackRenderState)itemStackRenderState).shulker_box_labels$getLabel();
        if (label == null || label.method_7960()) {
            return 0;
        }
        CustomItemTransformations customTransformations = CustomItemTransformationMap.getItemTransformation(label.method_7909());
        if (customTransformations == null) {
            return 0;
        }
        return customTransformations.getTopHeightOverflow();
    }

    @Nullable
    private static class_1792 getLabelItemFromModelKey(Object obj) {
        if (!(obj instanceof ArrayList)) {
            return null;
        }
        ArrayList ar = (ArrayList)obj;
        for (Object o : ar) {
            if (!(o instanceof LabelItemObject)) continue;
            LabelItemObject labelItemObject = (LabelItemObject)o;
            if (labelItemObject.label() == null || labelItemObject.label().method_7960()) {
                return null;
            }
            return labelItemObject.label().method_7909();
        }
        return null;
    }

    public static boolean usesBlockLight(boolean original, Object modelKey) {
        if (((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("disabled")) {
            return original;
        }
        if (modelKey == null) {
            return original;
        }
        if (!(modelKey instanceof ArrayList)) {
            return original;
        }
        ArrayList arrayList = (ArrayList)modelKey;
        ArrayList ar = arrayList;
        if (ar.isEmpty()) {
            return original;
        }
        if (ar.size() <= 2) {
            return original;
        }
        LabelItemObject labelItemObject = RenderUtils.findLabelItemObjectInModelIdentity(ar);
        if (labelItemObject == null) {
            return original;
        }
        if (((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("enabled") || ((String)CommonClient.config.renderFlat.get()).equalsIgnoreCase("onlyLabeled") && labelItemObject.label() != null && !labelItemObject.label().method_7960()) {
            return false;
        }
        return original;
    }

    @Unique
    @Nullable
    private static LabelItemObject findLabelItemObjectInModelIdentity(ArrayList<Object> list) {
        for (Object o : list) {
            if (!(o instanceof LabelItemObject)) continue;
            return (LabelItemObject)o;
        }
        return null;
    }
}

