/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.ui;

import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class LayoutItemText
extends LayoutItem<LayoutItemText> {
    private int color = -1;
    private final class_2561 text;
    private boolean centerVertical = false;
    private boolean centerHorizontal = false;

    public LayoutItemText(class_2561 text) {
        this.text = text;
    }

    public List<class_5481> getWrappedLines() {
        class_327 textRenderer = class_310.method_1551().field_1772;
        return textRenderer.method_1728((class_5348)this.text, this.getWidth());
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (this.isHidden()) {
            return;
        }
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        class_327 textRenderer = class_310.method_1551().field_1772;
        List<class_5481> lines = this.getWrappedLines();
        int startX = this.getX();
        int startY = this.getY();
        if (this.centerVertical) {
            int n = this.getHeight() / 2;
            Objects.requireNonNull(textRenderer);
            startY += n - 9 * lines.size() / 2;
        }
        if (this.centerHorizontal) {
            startX += this.getWidth() / 2 - this.getMaxLineWidth(lines) / 2;
        }
        for (int i = 0; i < lines.size(); ++i) {
            class_5481 line = lines.get(i);
            Objects.requireNonNull(textRenderer);
            context.method_51430(textRenderer, line, startX, startY + i * 9, this.color, false);
        }
    }

    private int getMaxLineWidth(List<class_5481> lines) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int maxWidth = 0;
        for (class_5481 line : lines) {
            maxWidth = Math.max(maxWidth, textRenderer.method_30880(line));
        }
        return maxWidth;
    }

    @Override
    public int getHeight() {
        if (this.isHidden()) {
            return 0;
        }
        if (this.isDynamicHeight()) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            int n = this.getWrappedLines().size();
            Objects.requireNonNull(textRenderer);
            return n * 9;
        }
        LayoutItemText that = this;
        if (this.getParent() != null && this.getHeightPercentage() != -1.0f) {
            return Math.round((float)(((LayoutItem)that.getParent()).getHeight() - 2 * ((LayoutItem)that.getParent()).getVerticalPadding()) * this.getHeightPercentage());
        }
        return this.height - 2 * this.verticalPadding;
    }

    @Override
    public int getWidth() {
        if (this.isHidden()) {
            return 0;
        }
        if (this.isDynamicWidth()) {
            return this.getMaxLineWidth(this.getWrappedLines());
        }
        LayoutItemText that = this;
        if (this.getParent() != null && this.getWidthPercentage() != -1.0f) {
            return Math.round((float)(((LayoutItem)that.getParent()).getWidth() - 2 * ((LayoutItem)that.getParent()).getHorizontalPadding()) * this.getWidthPercentage());
        }
        return this.width - 2 * this.horizontalPadding;
    }

    public LayoutItemText color(int color) {
        this.color = color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public LayoutItemText centerHorizontal() {
        this.centerHorizontal = true;
        return this;
    }

    public LayoutItemText centerVertical() {
        this.centerVertical = true;
        return this;
    }
}

