/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.render.ui;

import com.steveh259.shulkerboxlabels.common.config.ConfigScreen;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItem;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemButton;
import com.steveh259.shulkerboxlabels.common.render.ui.LayoutItemText;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class LayoutItemCheckbox
extends LayoutItemButton {
    private final class_2561 text;
    private final float textWidth = 0.8f;
    private boolean checkable = true;
    private int checkboxColor = -1;
    private Consumer<Boolean> checkedCallback;
    private boolean checked = false;

    public LayoutItemCheckbox(class_2561 text) {
        super((class_2561)class_2561.method_43470((String)""));
        this.text = text;
    }

    public LayoutItemCheckbox checked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public LayoutItemCheckbox onChecked(Consumer<Boolean> checked) {
        this.checkedCallback = checked;
        return this;
    }

    public void toggle() {
        if (!this.isCheckable()) {
            return;
        }
        boolean bl = this.checked = !this.checked;
        if (this.checkedCallback != null) {
            this.checkedCallback.accept(this.checked);
        }
    }

    @Override
    public LayoutItemCheckbox attachScreen(ConfigScreen parentScreen) {
        super.attachScreen(parentScreen);
        ((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)((LayoutItem)new LayoutItem().x(this.getX())).y(this.getY())).width(this.getWidth())).height(this.getHeight())).horizontalPadding(this.getHorizontalPadding())).verticalPadding(this.getVerticalPadding())).horizontalLayout()).children(new LayoutItem[]{((LayoutItemText)((LayoutItemText)new LayoutItemText(this.text).fullHeight()).widthPercentage(0.85f)).centerVertical(), ((LayoutItem)((LayoutItem)new LayoutItem().fullHeight()).widthPercentage(0.15f)).draw((ctx, x, y, width, height, deltaTicks) -> {
            int size = 8;
            int color = this.getCheckboxColor();
            ctx.method_51448().translate((float)(width - size), (float)(height - size) / 2.0f);
            if (this.checked) {
                ctx.method_25294(0, 0, size, size, color);
            } else {
                this.drawOutline((class_332)ctx, size, color);
            }
            if (!this.isCheckable()) {
                ctx.method_25294(2, 2, size - 2, size - 2, this.getCheckboxColor());
            }
        })}).attachScreen(parentScreen);
        return this;
    }

    private void drawOutline(class_332 guiGraphics, int size, int color) {
        guiGraphics.method_25294(0, 0, size, 1, color);
        guiGraphics.method_25294(size - 1, 0, size, size, color);
        guiGraphics.method_25294(0, size - 1, size, size, color);
        guiGraphics.method_25294(0, 0, 1, size, color);
    }

    @Override
    public int getHeight() {
        if (this.isDynamicHeight()) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            List lines = textRenderer.method_1728((class_5348)this.text, (int)Math.floor((float)this.getWidth() * this.textWidth));
            Objects.requireNonNull(textRenderer);
            return 9 * lines.size() + this.getVerticalPadding() * 2;
        }
        return super.getHeight();
    }

    public LayoutItemCheckbox setCheckable(boolean checkable) {
        this.checkable = checkable;
        return this;
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public LayoutItemCheckbox checkboxColor(int color) {
        this.checkboxColor = color;
        return this;
    }

    public int getCheckboxColor() {
        return this.checkboxColor;
    }
}

