/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.steveh259.shulkerboxlabels.common.Common;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public BoolValue renderLabels = new BoolValue(this, "renderLabels", true);
    public StringListValue renderFlat = new StringListValue(this, "renderFlat", "disabled", List.of("disabled", "enabled", "onlyLabeled"));
    public BoolValue renderFlatLarge = new BoolValue(this, "renderFlatLarge", true);
    public BoolValue rotateLabel = new BoolValue(this, "rotateLabel", false);
    public BoolValue renderIconInsideContainers = new BoolValue(this, "renderIconInsideContainers", true);
    public StringListValue labelRenderingModeHands = new StringListValue(this, "labelRenderingModeHands", "3D", List.of("3D", "ISO"));
    public StringListValue labelRenderingModeGUI = new StringListValue(this, "labelRenderingModeGUI", "ISO", List.of("3D", "ISO"));
    public StringListValue labelRenderingModeWorld = new StringListValue(this, "labelRenderingModeWorld", "ISO", List.of("3D", "ISO"));
    private final File oldFile = this.getOldConfigFile();
    private final File file = this.getConfigFile();

    public Config() {
        this.loadConfig();
    }

    private File getOldConfigFile() {
        Path configDir = this.getConfigDir();
        return new File(String.valueOf(configDir.resolve("labeled-shulker-boxes.json")));
    }

    private File getConfigFile() {
        Path configDir = this.getConfigDir();
        return new File(String.valueOf(configDir.resolve("shulker-box-labels.json")));
    }

    private void populateDefaults() {
        boolean wasConverted = false;
        JsonObject json = new JsonObject();
        if (this.file.length() > 0L) {
            try (FileReader reader = new FileReader(this.file);){
                json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                Common.LOG.error("An exception occured while reading the config file, resetting to default and recreating", (Throwable)e);
                this.recreateBrokenConfig();
            }
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                StringListValue stringListValue;
                BoolValue boolValue;
                Object obj = field.get(this);
                if (!(obj instanceof Value)) continue;
                Value value = (Value)field.get(this);
                String key = field.getName();
                if (json.has(key)) {
                    if (value instanceof BoolValue) {
                        boolValue = (BoolValue)value;
                        boolValue.set((Object)json.get(key).getAsBoolean());
                        continue;
                    }
                    if (!(value instanceof StringListValue)) continue;
                    stringListValue = (StringListValue)value;
                    String val = json.get(key).getAsString();
                    if (key.equalsIgnoreCase("renderFlat") && (val.equalsIgnoreCase("false") || val.equalsIgnoreCase("true"))) {
                        if (val.equalsIgnoreCase("false")) {
                            stringListValue.set("disabled");
                        } else if (val.equalsIgnoreCase("true")) {
                            stringListValue.set("enabled");
                        }
                        wasConverted = true;
                        continue;
                    }
                    stringListValue.set(val);
                    continue;
                }
                if (value instanceof BoolValue) {
                    boolValue = (BoolValue)value;
                    json.addProperty(key, (Boolean)boolValue.get());
                    continue;
                }
                if (!(value instanceof StringListValue)) continue;
                stringListValue = (StringListValue)value;
                json.addProperty(key, (String)stringListValue.get());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (wasConverted) {
            this.save();
        }
    }

    public void loadConfig() {
        if (!this.file.exists()) {
            if (this.oldFile.exists() && this.oldFile.renameTo(this.file)) {
                this.loadConfig();
                return;
            }
            if (this.createConfigFile()) {
                this.loadConfig();
            }
        } else {
            this.populateDefaults();
        }
    }

    private boolean createConfigFile() {
        boolean canContinue = false;
        Common.LOG.debug("Trying to create config file...");
        try {
            if (this.file.createNewFile()) {
                if (this.file.canWrite()) {
                    canContinue = true;
                } else {
                    Common.LOG.error("Cannot write to config file upon creation");
                }
            }
        }
        catch (Exception e) {
            Common.LOG.error("An error occured while reading config file", (Throwable)e);
        }
        return canContinue;
    }

    private void recreateBrokenConfig() {
        if (this.file.exists()) {
            if (this.file.delete()) {
                Common.LOG.info("Broken config file deleted.");
            } else {
                Common.LOG.error("Failed to delete broken config file.");
                return;
            }
        }
        try {
            if (this.file.createNewFile()) {
                Common.LOG.info("Fresh config file created.");
            } else {
                Common.LOG.error("Failed to create fresh config file.");
            }
        }
        catch (IOException e) {
            Common.LOG.error("Error recreating broken config file", (Throwable)e);
        }
    }

    public void save() {
        JsonObject json = new JsonObject();
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                Object obj = field.get(this);
                if (!(obj instanceof Value)) continue;
                Value value = (Value)field.get(this);
                String key = field.getName();
                if (value instanceof BoolValue) {
                    BoolValue boolValue = (BoolValue)value;
                    json.addProperty(key, (Boolean)boolValue.get());
                    continue;
                }
                if (!(value instanceof StringListValue)) continue;
                StringListValue stringListValue = (StringListValue)value;
                json.addProperty(key, (String)stringListValue.get());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        try (FileWriter writer = new FileWriter(this.file);){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json));
        }
        catch (IOException e) {
            Common.LOG.error("Failed to write config file", (Throwable)e);
        }
    }

    public void reset() {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                if (!(field.get(this) instanceof Value)) continue;
                Value value = (Value)field.get(this);
                value.set(value.defaultValue);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public Object getValueByKey(String key) {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                Object obj = field.get(this);
                if (!(obj instanceof Value)) continue;
                Value value = (Value)field.get(this);
                String k = field.getName();
                if (!k.equalsIgnoreCase(key)) continue;
                return value.get();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    private Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public class BoolValue
    extends Value<Boolean> {
        public BoolValue(Config this$0, String key, Boolean defaultValue) {
            super(this$0, key, defaultValue);
        }
    }

    public class StringListValue
    extends Value<String> {
        private final List<String> validOptions;

        private StringListValue(Config this$0, String key, String defaultValue, List<String> validOptions) {
            super(this$0, key, defaultValue);
            this.validOptions = validOptions;
        }

        @Override
        public void set(String value) {
            this.value = this.validOptions.stream().filter(s -> s.equalsIgnoreCase(value)).findFirst().orElse((String)this.defaultValue);
        }

        public List<String> getValidOptions() {
            return this.validOptions;
        }
    }

    private abstract class Value<T> {
        protected final String key;
        protected final T defaultValue;
        protected T value;

        private Value(Config config, String key, T defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }
    }
}

