/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.cache;

import com.steveh259.shulkerboxlabels.common.cache.CacheEntry;
import com.steveh259.shulkerboxlabels.common.cache.ContainerIconEntry;
import com.steveh259.shulkerboxlabels.common.cache.OptimisticFacingEntry;
import com.steveh259.shulkerboxlabels.common.cache.ShulkerBoxBlockEntityEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2627;
import org.jetbrains.annotations.Nullable;

public class Cache {
    public final HashMap<class_2627, ShulkerBoxBlockEntityEntry> shulkerBoxBlockEntityCache = new HashMap();
    public final HashMap<Integer, ContainerIconEntry> containerIconCache = new HashMap();
    public final HashMap<class_2338, OptimisticFacingEntry> optimisticFacingCache = new HashMap();

    public void clearCaches() {
        this.shulkerBoxBlockEntityCache.clear();
        this.containerIconCache.clear();
        this.optimisticFacingCache.clear();
    }

    public void removeAllEntriesOlderThan(long millis) {
        Map[] caches = new Map[]{this.shulkerBoxBlockEntityCache, this.containerIconCache, this.optimisticFacingCache};
        long now = System.currentTimeMillis();
        for (Map cache : caches) {
            Iterator it = cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                CacheEntry entry = (CacheEntry)e.getValue();
                if (now - entry.lastCheckedMillis <= millis) continue;
                it.remove();
            }
        }
    }

    public void putShulkerBoxBlockEntityEntry(class_2627 be, ShulkerBoxBlockEntityEntry entry) {
        this.shulkerBoxBlockEntityCache.put(be, entry);
    }

    @Nullable
    public ShulkerBoxBlockEntityEntry getShulkerBoxBlockEntityEntry(class_2627 be) {
        ShulkerBoxBlockEntityEntry entry = this.shulkerBoxBlockEntityCache.get(be);
        if (entry == null) {
            return null;
        }
        entry.resetTime();
        return entry;
    }

    public void putContainerIcon(int containerId, class_1799 icon) {
        if (icon == null || icon.method_7960()) {
            return;
        }
        ContainerIconEntry entry = new ContainerIconEntry(icon);
        this.containerIconCache.put(containerId, entry);
    }

    @Nullable
    public class_1799 getContainerIcon(int containerId) {
        ContainerIconEntry entry = this.containerIconCache.get(containerId);
        if (entry == null || entry.icon.method_7960()) {
            return null;
        }
        entry.resetTime();
        return entry.icon;
    }

    public void putOptimisticFacing(class_2338 pos, class_2350 facing) {
        OptimisticFacingEntry entry = new OptimisticFacingEntry(facing);
        this.optimisticFacingCache.put(pos, entry);
    }

    @Nullable
    public class_2350 getOptimisticFacing(class_2338 pos) {
        OptimisticFacingEntry entry = this.optimisticFacingCache.get(pos);
        if (entry == null) {
            return null;
        }
        entry.resetTime();
        return entry.facing;
    }

    public void removeOptimisticFacing(class_2338 pos) {
        this.optimisticFacingCache.remove(pos);
    }
}

